<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('de', array (
  'validators' => 
  array (
    'This value should be false.' => 'Dieser Wert sollte false sein.',
    'This value should be true.' => 'Dieser Wert sollte true sein.',
    'This value should be of type {{ type }}.' => 'Dieser Wert sollte vom Typ {{ type }} sein.',
    'This value should be blank.' => 'Dieser Wert sollte leer sein.',
    'The value you selected is not a valid choice.' => 'Sie haben einen ungültigen Wert ausgewählt.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Sie müssen mindestens {{ limit }} Möglichkeit wählen.|Sie müssen mindestens {{ limit }} Möglichkeiten wählen.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Sie dürfen höchstens {{ limit }} Möglichkeit wählen.|Sie dürfen höchstens {{ limit }} Möglichkeiten wählen.',
    'One or more of the given values is invalid.' => 'Einer oder mehrere der angegebenen Werte sind ungültig.',
    'This field was not expected.' => 'Dieses Feld wurde nicht erwartet.',
    'This field is missing.' => 'Dieses Feld fehlt.',
    'This value is not a valid date.' => 'Dieser Wert entspricht keiner gültigen Datumsangabe.',
    'This value is not a valid datetime.' => 'Dieser Wert entspricht keiner gültigen Datums- und Zeitangabe.',
    'This value is not a valid email address.' => 'Dieser Wert ist keine gültige E-Mail-Adresse.',
    'The file could not be found.' => 'Die Datei wurde nicht gefunden.',
    'The file is not readable.' => 'Die Datei ist nicht lesbar.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Die Datei ist zu groß ({{ size }} {{ suffix }}). Die maximal zulässige Größe beträgt {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'Der Dateityp ist ungültig ({{ type }}). Erlaubte Dateitypen sind {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Dieser Wert sollte kleiner oder gleich {{ limit }} sein.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Diese Zeichenkette ist zu lang. Sie sollte höchstens {{ limit }} Zeichen haben.|Diese Zeichenkette ist zu lang. Sie sollte höchstens {{ limit }} Zeichen haben.',
    'This value should be {{ limit }} or more.' => 'Dieser Wert sollte größer oder gleich {{ limit }} sein.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Diese Zeichenkette ist zu kurz. Sie sollte mindestens {{ limit }} Zeichen haben.|Diese Zeichenkette ist zu kurz. Sie sollte mindestens {{ limit }} Zeichen haben.',
    'This value should not be blank.' => 'Dieser Wert sollte nicht leer sein.',
    'This value should not be null.' => 'Dieser Wert sollte nicht null sein.',
    'This value should be null.' => 'Dieser Wert sollte null sein.',
    'This value is not valid.' => 'Dieser Wert ist nicht gültig.',
    'This value is not a valid time.' => 'Dieser Wert entspricht keiner gültigen Zeitangabe.',
    'This value is not a valid URL.' => 'Dieser Wert ist keine gültige URL.',
    'The two values should be equal.' => 'Die beiden Werte sollten identisch sein.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Die Datei ist zu groß. Die maximal zulässige Größe beträgt {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'Die Datei ist zu groß.',
    'The file could not be uploaded.' => 'Die Datei konnte nicht hochgeladen werden.',
    'This value should be a valid number.' => 'Dieser Wert sollte eine gültige Zahl sein.',
    'This file is not a valid image.' => 'Diese Datei ist kein gültiges Bild.',
    'This is not a valid IP address.' => 'Dies ist keine gültige IP-Adresse.',
    'This value is not a valid language.' => 'Dieser Wert entspricht keiner gültigen Sprache.',
    'This value is not a valid locale.' => 'Dieser Wert entspricht keinem gültigen Gebietsschema.',
    'This value is not a valid country.' => 'Dieser Wert entspricht keinem gültigen Land.',
    'This value is already used.' => 'Dieser Wert wird bereits verwendet.',
    'The size of the image could not be detected.' => 'Die Größe des Bildes konnte nicht ermittelt werden.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'Die Bildbreite ist zu groß ({{ width }}px). Die maximal zulässige Breite beträgt {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'Die Bildbreite ist zu gering ({{ width }}px). Die erwartete Mindestbreite beträgt {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'Die Bildhöhe ist zu groß ({{ height }}px). Die maximal zulässige Höhe beträgt {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'Die Bildhöhe ist zu gering ({{ height }}px). Die erwartete Mindesthöhe beträgt {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Dieser Wert sollte dem aktuellen Benutzerpasswort entsprechen.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Dieser Wert sollte genau {{ limit }} Zeichen lang sein.|Dieser Wert sollte genau {{ limit }} Zeichen lang sein.',
    'The file was only partially uploaded.' => 'Die Datei wurde nur teilweise hochgeladen.',
    'No file was uploaded.' => 'Es wurde keine Datei hochgeladen.',
    'No temporary folder was configured in php.ini.' => 'Es wurde kein temporärer Ordner in der php.ini konfiguriert oder der temporäre Ordner existiert nicht.',
    'Cannot write temporary file to disk.' => 'Kann die temporäre Datei nicht speichern.',
    'A PHP extension caused the upload to fail.' => 'Eine PHP-Erweiterung verhinderte den Upload.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Diese Sammlung sollte {{ limit }} oder mehr Elemente beinhalten.|Diese Sammlung sollte {{ limit }} oder mehr Elemente beinhalten.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Diese Sammlung sollte {{ limit }} oder weniger Elemente beinhalten.|Diese Sammlung sollte {{ limit }} oder weniger Elemente beinhalten.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Diese Sammlung sollte genau {{ limit }} Element beinhalten.|Diese Sammlung sollte genau {{ limit }} Elemente beinhalten.',
    'Invalid card number.' => 'Ungültige Kartennummer.',
    'Unsupported card type or invalid card number.' => 'Nicht unterstützer Kartentyp oder ungültige Kartennummer.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Dieser Wert ist keine gültige internationale Bankkontonummer (IBAN).',
    'This value is not a valid ISBN-10.' => 'Dieser Wert entspricht keiner gültigen ISBN-10.',
    'This value is not a valid ISBN-13.' => 'Dieser Wert entspricht keiner gültigen ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Dieser Wert ist weder eine gültige ISBN-10 noch eine gültige ISBN-13.',
    'This value is not a valid ISSN.' => 'Dieser Wert ist keine gültige ISSN.',
    'This value is not a valid currency.' => 'Dieser Wert ist keine gültige Währung.',
    'This value should be equal to {{ compared_value }}.' => 'Dieser Wert sollte gleich {{ compared_value }} sein.',
    'This value should be greater than {{ compared_value }}.' => 'Dieser Wert sollte größer als {{ compared_value }} sein.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Dieser Wert sollte größer oder gleich {{ compared_value }} sein.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Dieser Wert sollte identisch sein mit {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Dieser Wert sollte kleiner als {{ compared_value }} sein.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Dieser Wert sollte kleiner oder gleich {{ compared_value }} sein.',
    'This value should not be equal to {{ compared_value }}.' => 'Dieser Wert sollte nicht {{ compared_value }} sein.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Dieser Wert sollte nicht identisch sein mit {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Das Seitenverhältnis des Bildes ist zu groß ({{ ratio }}). Der erlaubte Maximalwert ist {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Das Seitenverhältnis des Bildes ist zu klein ({{ ratio }}). Der erwartete Minimalwert ist {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'Das Bild ist quadratisch ({{ width }}x{{ height }}px). Quadratische Bilder sind nicht erlaubt.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'Das Bild ist im Querformat ({{ width }}x{{ height }}px). Bilder im Querformat sind nicht erlaubt.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'Das Bild ist im Hochformat ({{ width }}x{{ height }}px). Bilder im Hochformat sind nicht erlaubt.',
    'An empty file is not allowed.' => 'Eine leere Datei ist nicht erlaubt.',
    'The host could not be resolved.' => 'Der Hostname konnte nicht aufgelöst werden.',
    'This value does not match the expected {{ charset }} charset.' => 'Dieser Wert entspricht nicht dem erwarteten Zeichensatz {{ charset }}.',
    'This is not a valid Business Identifier Code (BIC).' => 'Dieser Wert ist kein gültiger BIC.',
    'Error' => 'Fehler',
    'This is not a valid UUID.' => 'Dies ist keine gültige UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'Dieser Wert sollte ein Vielfaches von {{ compared_value }} sein.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Diese internationale Bankleitzahl (BIC) ist nicht mit der IBAN {{ iban }} assoziiert.',
    'This value should be valid JSON.' => 'Dieser Wert sollte gültiges JSON sein.',
    'This collection should contain only unique elements.' => 'Diese Sammlung darf keine doppelten Elemente enthalten.',
    'This value should be positive.' => 'Diese Zahl sollte positiv sein.',
    'This value should be either positive or zero.' => 'Diese Zahl sollte entweder positiv oder 0 sein.',
    'This value should be negative.' => 'Diese Zahl sollte negativ sein.',
    'This value should be either negative or zero.' => 'Diese Zahl sollte entweder negativ oder 0 sein.',
    'This value is not a valid timezone.' => 'Dieser Wert ist keine gültige Zeitzone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Dieses Passwort ist Teil eines Datenlecks, es darf nicht verwendet werden.',
    'This value should be between {{ min }} and {{ max }}.' => 'Dieser Wert sollte zwischen {{ min }} und {{ max }} sein.',
    'This value is not a valid hostname.' => 'Dieser Wert ist kein gültiger Hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'Die Anzahl an Elementen in dieser Sammlung sollte ein Vielfaches von {{ compared_value }} sein.',
    'This value should satisfy at least one of the following constraints:' => 'Dieser Wert sollte eine der folgenden Bedingungen erfüllen:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Jedes Element dieser Sammlung sollte seine eigene Menge an Bedingungen erfüllen.',
    'This form should not contain extra fields.' => 'Dieses Formular sollte keine zusätzlichen Felder enthalten.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Die hochgeladene Datei ist zu groß. Versuchen Sie bitte eine kleinere Datei hochzuladen.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'Der CSRF-Token ist ungültig. Versuchen Sie bitte das Formular erneut zu senden.',
    'fos_user.username.already_used' => 'Der Benutzername ist schon in Benutzung.',
    'fos_user.username.blank' => 'Bitte geben Sie einen Benutzernamen ein.',
    'fos_user.username.short' => 'Der Benutzername ist zu kurz.',
    'fos_user.username.long' => 'Der Benutzername ist zu lang.',
    'fos_user.email.already_used' => 'Die E-Mail wird bereits verwendet.',
    'fos_user.email.blank' => 'Bitte geben Sie eine E-Mail ein.
',
    'fos_user.email.short' => 'Die E-Mail ist zu kurz.
',
    'fos_user.email.long' => 'Die E-Mail ist zu lang.
',
    'fos_user.email.invalid' => 'Die E-Mail ist ungültig.',
    'fos_user.password.blank' => 'Bitte Passwort eingeben.',
    'fos_user.password.short' => 'Das Passwort ist zu kurz.',
    'fos_user.password.mismatch' => 'Die eingegebenen Passwörter stimmen nicht überein.',
    'fos_user.new_password.blank' => 'Bitte geben Sie ein neues Passwort an.',
    'fos_user.new_password.short' => 'Das neue Passwort ist zu kurz.',
    'fos_user.current_password.invalid' => 'Das angegebene Passwort ist ungültig.',
    'fos_user.group.blank' => 'Bitte geben Sie einen Namen an.',
    'fos_user.group.short' => 'Dieser Name ist zu kurz.',
    'fos_user.group.long' => 'Dieser Name ist zu lang.',
    'fos_group.name.already_used' => 'Dieser Name wird bereits verwendet.',
    'This value is not a valid captcha.' => 'Das war keine gültige Lösung für das Captcha.',
    'The captcha was not resolved on the right domain.' => 'Das Captcha war nicht auf das richtige Domäne angezeigt.',
    'Please enter a message' => 'Bitte geben Sie eine Nachricht ein',
    'Please enter a permalink' => 'Bitte geben Sie einen permanenten Link ein',
    'Please enter an id' => 'Bitte geben Sie eine ID ein',
    'Please provide a valid url' => 'Bitte geben Sie eine gültige URL an',
    'The file should be an image' => 'Die Datei muss ein Bild sein',
    'The message is too short|The message is too short' => 'Die Nachricht ist zu kurz | Die Nachricht ist zu kurz',
    'The password fields must match.' => 'Die Passwortfelder müssen übereinstimmen.',
    'You must set the default locale at least for the translation fields' => 'Sie müssen zumindest für die Übersetzungsfelder das Standardgebietsschema festlegen',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Es ist ein Fehler bei der Authentifikation aufgetreten.',
    'Authentication credentials could not be found.' => 'Es konnten keine Zugangsdaten gefunden werden.',
    'Authentication request could not be processed due to a system problem.' => 'Die Authentifikation konnte wegen eines Systemproblems nicht bearbeitet werden.',
    'Invalid credentials.' => 'Fehlerhafte Zugangsdaten.',
    'Cookie has already been used by someone else.' => 'Cookie wurde bereits von jemand anderem verwendet.',
    'Not privileged to request the resource.' => 'Keine Rechte, um die Ressource anzufragen.',
    'Invalid CSRF token.' => 'Ungültiges CSRF-Token.',
    'No authentication provider found to support the authentication token.' => 'Es wurde kein Authentifizierungs-Provider gefunden, der das Authentifizierungs-Token unterstützt.',
    'No session available, it either timed out or cookies are not enabled.' => 'Keine Session verfügbar, entweder ist diese abgelaufen oder Cookies sind nicht aktiviert.',
    'No token could be found.' => 'Es wurde kein Token gefunden.',
    'Username could not be found.' => 'Der Benutzername wurde nicht gefunden.',
    'Account has expired.' => 'Der Account ist abgelaufen.',
    'Credentials have expired.' => 'Die Zugangsdaten sind abgelaufen.',
    'Account is disabled.' => 'Der Account ist deaktiviert.',
    'Account is locked.' => 'Der Account ist gesperrt.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Vorherige',
    'label_next' => 'Nächste',
  ),
  'VichUploaderBundle' => 
  array (
    'download' => 'herunterladen',
    'form.label.delete' => 'Löschen?',
  ),
  'FOSUserBundle' => 
  array (
    'group.edit.submit' => 'Gruppe aktualisieren',
    'group.show.name' => 'Gruppenname',
    'group.new.submit' => 'Gruppe erstellen',
    'group.flash.updated' => 'Die Gruppe wurde aktualisiert.',
    'group.flash.created' => 'Die Gruppe wurde erstellt.',
    'group.flash.deleted' => 'Die Gruppe wurde gelöscht.',
    'security.login.username' => 'Username',
    'security.login.password' => 'Passwort',
    'security.login.remember_me' => 'erinnere mich',
    'security.login.submit' => 'Anmelden',
    'profile.show.username' => 'Benutzername',
    'profile.show.email' => 'E-Mail',
    'profile.edit.submit' => 'Benutzer aktualisieren',
    'profile.flash.updated' => 'Das Benutzerprofil wurde aktualisiert.',
    'change_password.submit' => 'Passwort ändern',
    'change_password.flash.success' => 'Das Passwort wurde geändert.',
    'registration.check_email' => 'Eine E-Mail wurde an %email% gesendet. Es enthält einen Aktivierungslink, den Sie anklicken müssen, um Ihr Konto zu aktivieren.',
    'registration.confirmed' => 'Herzlichen Glückwunsch %username%, Ihr Konto ist jetzt aktiviert.',
    'registration.back' => 'Zurück zur Ursprungsseite.',
    'registration.submit' => 'Registrieren',
    'registration.flash.user_created' => 'Der Benutzer wurde erfolgreich erstellt.',
    'registration.email.subject' => 'Wilkommen %username%!',
    'registration.email.message' => 'Hallo %username%!

Um die Aktivierung Ihres Kontos abzuschließen, klicken Sie bitte auf den folgenden Link %confirmationUrl%

Dieser Link kann nur einmal verwendet werden, um Ihr Konto zu bestätigen.

Grüße,
EVETIX',
    'resetting.check_email' => 'Eine E-Mail wurde an sie gesendet. Sie enthält einen Link, auf den Sie klicken müssen, um Ihr Passwort zurückzusetzen.
Hinweis: Sie können nur einmal innerhalb von %tokenLifetime% Stunden ein neues Passwort anfordern.

Wenn Sie keine E-Mail erhalten haben, überprüfen Sie Ihren Spam-Ordner oder versuchen Sie es erneut.',
    'resetting.request.username' => 'Username oder email Adresse',
    'resetting.request.submit' => 'Passwort zurücksetzen',
    'resetting.reset.submit' => 'Passwort ändern',
    'resetting.flash.success' => 'Das Passwort wurde erfolgreich zurückgesetzt.',
    'resetting.email.subject' => 'Passwort zurücksetzen',
    'resetting.email.message' => 'Hallo %username%!

Um Ihr Passwort zurückzusetzen - besuchen Sie bitte %confirmationUrl%

Grüße,
EVETIX',
    'layout.logout' => 'Abmelden',
    'layout.login' => 'Anmelden',
    'layout.register' => 'Registrieren',
    'layout.logged_in_as' => 'Angemeldet als %username%',
    'form.group_name' => 'Gruppenname',
    'form.username' => 'Benutzername',
    'form.email' => 'E-Mail-Adresse',
    'form.current_password' => 'Derzeitiges Passwort',
    'form.password' => 'Passwort',
    'form.password_confirmation' => 'Passwort bestätigen',
    'form.new_password' => 'Neues Passwort',
    'form.new_password_confirmation' => 'Neues Passwort bestätigen',
    'Password' => 'Passwort',
    'Privacy policy' => 'Datenschutzerklärung',
    'Terms of service' => 'AGB',
    'Welcome' => 'Wilkommen',
  ),
  'HWIOAuthBundle' => 
  array (
    'header.connecting' => 'Verbinden',
    'header.success' => '"%name%" erfolgreich mit Benutzeraccount verbunden!',
    'header.register' => 'Neuen Benutzeraccount mit dem Namen "%name%" erstellen',
    'header.registration_success' => 'Benutzeraccount "%username%" erfolgreich angelegt und verknüpft!',
    'connect.confirm.cancel' => 'Abbrechen',
    'connect.confirm.submit' => 'Benutzeraccount verbinden',
    'connect.confirm.text' => 'Sicher, dass Sie Ihren %service% Account "%name%" mit Ihrem aktuellen Benutzeraccount verknüpfen möchten?',
    'connect.registration.cancel' => 'Abbrechen',
    'connect.registration.submit' => 'Benutzeraccount registrieren',
  ),
  'time' => 
  array (
    'diff.ago.year' => 'vor einem Jahr|vor %count% Jahren',
    'diff.ago.month' => 'vor einem Monat|vor %count% Monaten',
    'diff.ago.day' => 'vor einem Tag|vor %count% Tagen',
    'diff.ago.hour' => 'vor einer Stunde|vor %count% Stunden',
    'diff.ago.minute' => 'vor einer Minute|vor %count% Minuten',
    'diff.ago.second' => 'vor einer Sekunde|vor %count% Sekunden',
    'diff.empty' => 'jetzt',
    'diff.in.second' => 'in einer Sekunde|in %count% Sekunden',
    'diff.in.hour' => 'in einer Stunde|in %count% Stunden',
    'diff.in.minute' => 'in einer Minute|in %count% Minuten',
    'diff.in.day' => 'in einem Tag|in %count% Tagen',
    'diff.in.month' => 'in einem Monat|in %count% Monaten',
    'diff.in.year' => 'in einem Jahr|in %count% Jahren',
  ),
  'FOSCommentBundle' => 
  array (
    'fos_comment_comment_new_headline_first' => 'Du bist der erste der dies kommentiert !',
    'fos_comment_comment_new_headline' => 'Ein neues Kommentar hinzufügen',
    'fos_comment_comment_new_submit' => 'speichern',
    'fos_comment_comment_new_cancel' => 'Abbrechen',
    'fos_comment_comment_edit_submit' => 'speichern',
    'fos_comment_comment_edit_cancel' => 'Abbrechen',
    'fos_comment_comment_reply_reply_to' => 'wiederholen',
    'fos_comment_comment_reply_cancel' => 'abbrechen',
    'fos_comment_comment_show_by' => 'Von',
    'fos_comment_comment_show_voteup' => 'Aufwerten',
    'fos_comment_comment_show_votedown' => 'Abwerten',
    'fos_comment_comment_show_reply' => 'wiederholen',
    'fos_comment_comment_vote_score' => 'voten',
    'fos_comment_comment_tree_load_more' => 'Lade weitere Antworten',
    'fos_comment_rss_feed' => 'RSS Feed',
    'fos_comment_thread_close' => 'Thread schließen',
    'fos_comment_thread_open' => 'Thread öffnen',
    'fos_comment_thread_comment_count' => 'Kommentare',
    'fos_comment_comment_edit' => 'Editieren',
    'fos_comment_comment_delete' => 'Löschen',
    'fos_comment_comment_undelete' => 'Kommentar wiederhergestellt',
    'fos_comment_comment_deleted' => 'Kommentar löschen',
  ),
  'messages' => 
  array (
    'coresphere_console.headline.index' => 'Konsole',
    'coresphere_console.working_directory' => 'Arbeitsverzeichnis',
    'coresphere_console.environment' => 'Umgebung',
    'coresphere_console.welcome_message' => 'Schreibe %command% um eine Liste mit allen verfügbaren Befehlen zu bekommen.',
    'coresphere_console.loading' => 'Lade...',
    'coresphere_console.suggestion_head' => 'Meintest du:',
    'coresphere_console.empty_response' => 'Fertig!',
    '%cartElementsCount% event(s) currently in cart' => '%cartElementsCount% Event(s) derzeit im Warenkorb',
    '%mins% left before tickets are released' => '%mins% übrig, bevor die Tickets freigegeben werden',
    '%resultsCount% attendee(s) found' => '%resultsCount% asistente(s) encontrado(s)',
    '%resultsCount% event date(s) found' => '%resultsCount% Teilnehmer gefunden',
    '%resultsCount% event(s)' => '%resultsCount% Ereignis(e)',
    '%resultsCount% event(s) currently on sale' => '%resultsCount% Event(s) derzeit im Angebot',
    '%resultsCount% event(s) found' => '%resultsCount% Ereignis(e) gefunden',
    '%resultsCount% post(s) found' => '%resultsCount% Beitrag(e) gefunden',
    '%resultsCount% result(s) found' => '%resultsCount% Ergebnis(e) gefunden',
    '%resultsCount% reviews(s) found' => '%resultsCount% Bewertungen gefunden',
    '%tickets% ticket(s) are still reserved for you, please wait until the reservation expires at %expirationDate% in order to purchase more tickets' => '%tickets% Ticket(s) sind noch für Sie reserviert, bitte warten Sie, bis die Reservierung am %expirationDate% abläuft, um weitere Tickets zu kaufen',
    '%websiteName% is undergoing a scheduled maintenance.' => '%websiteName% wird einer geplanten Wartung unterzogen.',
    1 => '1',
    '1 star' => '1 Stern',
    10 => '10',
    11 => '11',
    12 => '12',
    13 => '13',
    14 => '14',
    15 => '15',
    2 => '2',
    '2 stars' => '2 Sterne',
    3 => '3',
    '3 stars' => '3 Sterne',
    4 => '4',
    '4 stars' => '4 Sterne',
    5 => '5',
    '5 stars' => '5 Sterne',
    6 => '6',
    7 => '7',
    8 => '8',
    9 => '9',
    'A payout can not be requested on a free event date' => 'An einem freien Veranstaltungstermin kann keine Auszahlung beantragt werden',
    'A payout is already requested for this event date' => 'Für diesen Veranstaltungstermin ist bereits eine Auszahlung beantragt',
    'About the organizer' => 'Über den Veranstalter',
    'About us' => 'Über uns',
    'Absatz' => 'Absatz',
    'Access denied' => 'Zugriff verweigert',
    'Access granted' => 'Zugriff gewährt',
    'Access is denied. You may not have the appropriate permissions to access this resource.' => 'Der Zugriff wird verweigert. Möglicherweise verfügen Sie nicht über die entsprechenden Berechtigungen, um auf diese Ressource zuzugreifen.',
    'Account' => 'Account',
    'Account information' => 'Account Information',
    'Account settings' => 'Account Einstellungen',
    'Account status' => 'Account Status',
    'Actions' => 'Aktionen',
    'Active attendees' => 'Aktive Teilnehmer',
    'Active organizers' => 'Aktive Veranstalter',
    'Add a blog post' => 'Einen Blogbeitrag hinzufügen',
    'Add a help center article' => 'Hilfeartikel hinzufügen',
    'Add a new amenity' => 'Fügen Sie eine neue Annehmlichkeiten hinzu',
    'Add a new audience' => 'Eine neue Zielgruppe hinzufügen',
    'Add a new blog post' => 'Füge einen neuen Blogbeitrag hinzu',
    'Add a new blog post category' => 'Fügen Sie eine neue Blog-Post-Kategorie hinzu',
    'Add a new category' => 'Fügen Sie eine neue Kategorie hinzu',
    'Add a new country' => 'Neues Land hinzufügen',
    'Add a new currency' => 'Fügen Sie eine neue Währung hinzu',
    'Add a new event' => 'Fügen Sie eine neue Veranstaltung hinzu',
    'Add a new help center article' => 'Neuen Hilfeartikel hinzufügen',
    'Add a new help center category' => 'Fügen Sie eine neue Hilfe-Center-Kategorie hinzu',
    'Add a new language' => 'Eine neue Sprache hinzufügen',
    'Add a new page' => 'Eine neue Seite hinzufügen',
    'Add a new payment gateway' => 'Fügen Sie ein neues Zahlungsgateway hinzu',
    'Add a new point of sale' => 'Fügen Sie eine neue Verkaufsstelle hinzu',
    'Add a new scanner' => 'Neuen Scanner hinzufügen',
    'Add a new venue' => 'Fügen Sie einen neuen Veranstaltungsort hinzu',
    'Add a new venue type' => 'Fügen Sie einen neuen Veranstaltungsorttyp hinzu',
    'Add events to your favorites by clicking the heart button' => 'Fügen Sie Ereignisse zu Ihren Favoriten hinzu, indem Sie auf die Herz-Schaltfläche klicken',
    'Add other images that represent your event to be displayed as a gallery' => 'Fügen Sie andere Bilder hinzu, die Ihre Veranstaltung repräsentieren, um als Galerie angezeigt zu werden',
    'Add to calendar' => 'Zum Kalender hinzufügen',
    'Add to cart' => 'In den Warenkorb legen',
    'Add to favorites' => 'Zu den Favoriten hinzufügen',
    'Add your review' => 'Fügen Sie Ihre Bewertung hinzu',
    'Add your review for %eventname%' => 'Fügen Sie Ihre Bewertung für %Eventname% hinzu',
    'Added to favorites by' => 'Zu Favoriten hinzugefügt von',
    'Additional note' => 'Zusätzliche Anmerkung',
    'Address' => 'Adresse',
    'After editing a translation message, go to the Console page and execute the following command: cache:clear --env=prod in order to apply the changes in the production environment' => 'Rufen Sie nach dem Bearbeiten einer Übersetzungsnachricht die Konsolenseite auf und führen Sie den folgenden Befehl aus: cache:clear --env=prod, um die Änderungen in der Produktionsumgebung zu übernehmen',
    'All' => 'Alle',
    'All categories' => 'Alle Kategorien',
    'All event dates for an organizer' => 'Alle Veranstaltungstermine für einen Veranstalter',
    'All orders for an organizer' => 'Alle Bestellungen für einen Veranstalter',
    'All payout requests for an organizer' => 'Alle Auszahlungsanfragen für einen Veranstalter',
    'Allow Paypal as a payout method for the organizers to receive their revenue' => 'Erlaube Paypal als Auszahlungsmethode für die Organisatoren, um ihre Einnahmen zu erhalten',
    'Allow Stripe as a payout method for the organizers to receive their revenue' => 'Erlaube Stripe als Auszahlungsmethode für die Organisatoren, um ihre Einnahmen zu erhalten',
    'Allow attendees to leave reviews' => 'Teilnehmern erlauben, Bewertungen zu hinterlassen',
    'Allow tap to check in on the scanner app' => 'Einchecken in der Scanner-App durch Tippen zulassen',
    'Already have an account?' => 'Sie haben bereits ein Konto?',
    'Alternative date and time format' => 'Alternatives Datums- und Uhrzeitformat',
    'Amenities' => 'Ausstattung',
    'Amount' => 'Betrag',
    'An error has occured' => 'Ein Fehler ist aufgetreten',
    'An error has occured while processing your request' => 'Bei der Bearbeitung Ihrer Anfrage ist ein Fehler aufgetreten',
    'An error might occur if the command execution time reaches your PHP max_execution_time directive' => 'Ein Fehler kann auftreten, wenn die Befehlsausführungszeit Ihre PHP-Anweisung max_execution_time erreicht ist',
    'Anweisungen' => 'Anweisungen',
    'Anything' => 'Irgendetwas',
    'Anytime' => 'Jederzeit',
    'Anywhere' => 'Irgendwo',
    'App Debugging' => 'App Debuggin',
    'App Environment' => 'App Environment',
    'App Secret' => 'App Secret',
    'Application layout' => 'Application layout',
    'Application theme' => 'Application theme',
    'Approve' => 'Genehmigt',
    'Approved' => 'Zugelassen',
    'Are you ready to take your' => 'Bist du bereit, deine',
    'Article details' => 'Artikeldetails',
    'Articles' => 'Artikel',
    'Articles count' => 'Artikel zählen',
    'Artists' => 'Künstler',
    'Assigned events' => 'Zugewiesene Ereignisse',
    'Attendance' => 'Teilnahme',
    'Attendee' => 'Teilnehmer',
    'Attendee / POS' => 'Teilnehmer / POS',
    'Attendee Name / Email' => 'Teilnehmername / E-Mail',
    'Attendee Registration' => 'Teilnehmerregistrierung',
    'Attendee information' => 'Teilnehmerinformationen',
    'Attendee name or email, ticket reference, order reference' => 'Teilnehmername oder E-Mail, Ticketreferenz, Bestellreferenz',
    'Attendee status' => 'Teilnehmerstatus',
    'Attendee tickets' => 'Teilnehmerkarten',
    'Attendees' => 'Teilnehmer',
    'Attendees Check In' => 'Teilnehmer eingecheckt',
    'Attendees check-in' => 'Teilnehmer-Check-in',
    'Attendees list' => 'Teilnehmerliste',
    'Attendees reviews' => 'Teilnehmerbewertungen',
    'Attendees summary' => 'Teilnehmerübersicht',
    'Audience' => 'Publikum',
    'Audiences' => 'Zielgruppen',
    'Authentification Pages' => 'Authentifizierungsseiten',
    'Authorized' => 'Authorized',
    'Automatically canceled before deletion' => 'Vor dem Löschen automatisch storniert',
    'Availability' => 'Verfügbarkeit',
    'Available languages' => 'Verfügbare Sprachen',
    'Availibility' => 'Verfügbarkeit',
    'Avatar' => 'Avatar',
    'Awaiting payment' => 'Warten auf Zahlungseingang',
    'Beschreibung' => 'Beschreibung',
    'Besides the qr code scanning feature, the scanner account will be able to check in the attendees using a list and a button' => 'Neben der QR-Code-Scanfunktion kann das Scannerkonto die Teilnehmer über eine Liste und eine Schaltfläche einchecken',
    'Best regards, the %website_name% team' => 'Mit freundlichen Grüßen, das %website_name%',
    'Billing information' => 'Abrechnungsdaten',
    'Birthdate' => 'Geburtstag',
    'Blog' => 'Blog',
    'Blog Pages' => 'Blogseiten',
    'Blog page' => 'Blogseite',
    'Blog post' => 'Blog post',
    'Blog posts count' => 'Blogbeiträge zählen',
    'Blog settings' => 'Blog Einstellungen',
    'Bought on' => 'Gekauft am',
    'Bought tickets' => 'Tickets gekauft',
    'Browse events' => 'Veranstaltungen durchsuchen',
    'Buy more tickets' => 'Mehr Tickets kaufen',
    'Buy tickets' => 'Tickets kaufen',
    'By clicking on send, an email is going to be sent to the chosen email address. Make sure to save the configuration to be tested before testing.' => 'By clicking on send, an email is going to be sent to the chosen email address. Make sure to save the configuration to be tested before testing.',
    'By clicking the Sign Up button, I agree to' => 'Durch Klicken auf die Schaltfläche Anmelden zustimmen',
    'CCY' => 'CCY',
    'Cancel' => 'Abbrechen',
    'Canceled' => 'Abgebrochen',
    'Captured' => 'Eingefangen',
    'Cart' => 'Warenkorb',
    'Cart elements' => 'Warenkorb-Elemente',
    'Cash / Check / Bank Transfer / Other' => 'Bargeld / Scheck / Banküberweisung / Sonstiges',
    'Cash / Check / Offline' => 'Bargeld / Scheck / Offline',
    'Categories' => 'Kategorien',
    'Categories page' => 'Kategorienseite',
    'Category' => 'Kategorie',
    'Ccy' => 'Ccy',
    'Change password' => 'Passwort ändern',
    'Check In' => 'Einchecken',
    'Check In Attendees for this event date' => 'Teilnehmer für dieses Veranstaltungsdatum einchecken',
    'Check your email inbox' => 'Überprüfen Sie Ihren E-Mail-Posteingang',
    'Checked In At' => 'Eingecheckt in',
    'Checked In Only' => 'Nur eingecheckt',
    'Checkout' => 'Auschecken',
    'Checkout settings' => 'Checkout-Einstellungen',
    'Choose a payment gateway' => 'Wählen Sie ein Zahlungsgateway',
    'Choose the link destination page' => 'Wählen Sie die Zielseite des Links',
    'Choose the right image to represent your event (We recommend using at least a 1200x600px (2:1 ratio) image )' => 'Wählen Sie das richtige Bild aus, um Ihre Veranstaltung darzustellen (Wir empfehlen die Verwendung eines Bildes mit mindestens 1200 x 600 Pixel (2:1).)',
    'City' => 'Stadt',
    'Clear the application cache for the development environment' => 'Löschen Sie den Anwendungscache für die Entwicklungsumgebung',
    'Clear the application cache for the production environment' => 'Löschen Sie den Anwendungscache für die Produktionsumgebung',
    'Click here' => 'klick hier',
    'Click on a date to view tickets' => 'Klicken Sie auf ein Datum, um Tickets anzuzeigen',
    'Close' => 'Schließen',
    'Compact' => 'Kompakt',
    'Confirm account' => 'Konto bestätigen',
    'Confirm payment and place order' => 'Zahlung bestätigen und Bestellung aufgeben',
    'Confirm payout request' => 'Auszahlungsanfrage bestätigen',
    'Contact' => 'Kontakt',
    'Contact & Social media' => 'Kontakt und soziale Netzwerke',
    'Contact Us' => 'Kontaktiere uns',
    'Contact address' => 'Kontaktadresse',
    'Contact email' => 'Kontakt Email',
    'Contact email address' => 'Kontakt-E-Mailadresse',
    'Contact fax' => 'Kontaktfax',
    'Contact information' => 'Kontaktinformation',
    'Contact phone' => 'Kontakt-Telefon',
    'Contact phone number' => 'Kontakt Telefonnummer',
    'Contact the attendee' => 'Kontaktieren Sie den Teilnehmer',
    'Contact the organizer' => 'Kontaktiere den Veranstalter',
    'Contact us' => 'Kontaktiere uns',
    'Contenido' => 'Inhalt',
    'Content' => 'Inhalt',
    'Contente' => 'Contente',
    'Contenu' => 'Inhalt',
    'Cookie policy' => 'Cookie-Richtlinie',
    'Cookie policy page slug' => 'Cookie-Richtlinien-Seitenslug',
    'Copyright' => 'Copyright',
    'Count' => 'Zählen',
    'Countries' => 'Länder',
    'Country' => 'Land',
    'Country code' => 'Ländercode',
    'Cover photo' => 'Titelbild',
    'Cover picture' => 'Titelbild',
    'Create Account' => 'Konto erstellen',
    'Create event' => 'Veranstaltung erstellen',
    'Create my event' => 'Meine Veranstaltung erstellen',
    'Created by organizer' => 'Erstellt vom Veranstalter',
    'Creation date' => 'Erstellungsdatum',
    'Creation date / Last login' => 'Erstellungsdatum / Letzter Login',
    'Credit or debit card' => 'Kredit- oder Debitkarte',
    'Currency' => 'Währung',
    'Currency symbol' => 'Währungssymbol',
    'Currency symbol position' => 'Position des Währungssymbols',
    'Currently in cart' => 'Derzeit im Warenkorb',
    'Custom css' => 'Custom css',
    'Custom hero' => 'Custom hero',
    'Custom hero background image' => 'Benutzerdefiniertes Hero-Hintergrundbild',
    'Custom hero title and paragraph translation' => 'Benutzerdefinierte Hero Titel- und Absatzübersetzung',
    'Custom link' => 'Benutzerdefinierten Link',
    'Dark' => 'Dunkel',
    'Dark blue' => 'Dunkelblau',
    'Dashboard' => 'Dashboard',
    'Dashboard Pages' => 'Dashboard-Seiten',
    'Date' => 'Datum',
    'Date and time format' => 'Datums- und Zeitformat',
    'Date only format' => 'Nur Datumsformat',
    'Dates' => 'Datum',
    'Default language' => 'Standardsprache',
    'Delete' => 'Löschen',
    'Delete permanently' => 'Dauerhaft löschen',
    'Deleted' => 'Löschen',
    'Deletion date' => 'Löschdatum',
    'Descripción' => 'Beschreibung',
    'Description' => 'Beschreibung',
    'Descrição' => 'Descrição',
    'Details' => 'Details',
    'Development' => 'Entwicklung',
    'Development environment is used for development purposes only' => 'Die Entwicklungsumgebung wird nur für Entwicklungszwecke verwendet',
    'Disable' => 'Inhabilitar',
    'Disabled' => 'Deaktiviert',
    'Disabled only' => 'Nur deaktiviert',
    'Display itinerary bicycling' => 'Fahrradroute anzeigen',
    'Display itinerary driving' => 'Fahrtroute anzeigen',
    'Display itinerary on public transportation' => 'Reiseroute mit öffentlichen Verkehrsmitteln anzeigen',
    'Display itinerary walking' => 'Wanderroute anzeigen',
    'Display top 4 featured categories (footer section menu only)' => 'Top 4 empfohlene Kategorien anzeigen (nur Fußzeilenmenü)',
    'Disqus comments' => 'Disqus-Kommentare',
    'Disqus subdomain' => 'Disqus-Subdomain',
    'Draft' => 'Entwurf',
    'Draft only' => 'Nur Entwurf',
    'Early bird, General admission, VIP...' => 'Frühbucher, Stehplatz, VIP...',
    'Edit' => 'Editieren',
    'Edit the menu' => 'Menü editieren',
    'Edit your organizer profile' => 'Bearbeiten Sie Ihr Veranstalterprofil',
    'Editing the title after the event is saved won\'t change the event url' => 'Wenn Sie den Titel bearbeiten, nachdem das Ereignis gespeichert wurde, wird die Ereignis-URL nicht geändert.',
    'Elapsed only' => 'Nur abgelaufene',
    'Elements' => 'Elemente',
    'Email' => 'Email',
    'Email address' => 'Emailadresse',
    'Empty cart' => 'Leerer Warenkorb',
    'En cabeza' => 'Im Kopf',
    'En-tête' => 'In deinen Gedanken',
    'Enable' => 'Aktivieren',
    'Enable Facebook Social Login' => 'Facebook Social Login aktivieren',
    'Enable Google Repatcha' => 'Google-Repatcha aktivieren',
    'Enable Google Social Login' => 'Google Social Login aktivieren',
    'Enable comments' => 'Kommentare aktivieren',
    'Enable maintenance mode to display a maintenance page for all users but the users who are granted the ROLE_ADMINISTRATOR role, if you lost your session, you can edit the MAINTENANCE_MODE parameter directly in the .env file' => 'Aktivieren Sie den Wartungsmodus, um eine Wartungsseite für alle Benutzer anzuzeigen, außer den Benutzern, denen die Rolle ROLE_ADMINISTRATOR gewährt wurde. Wenn Sie Ihre Sitzung verloren haben, können Sie den Parameter MAINTENANCE_MODE direkt in der .env-Datei bearbeiten',
    'Enable newsletter' => 'Newsletter aktivieren',
    'Enable reviews' => 'Bewertungen aktivieren',
    'Enable sales for this event date ?' => 'Verkäufe für dieses Veranstaltungsdatum aktivieren?',
    'Enable sales for this ticket ?' => 'Verkauf für dieses Ticket aktivieren?',
    'Enable to display stacktraces on error pages or if cache files should be dynamically rebuilt on each request' => 'Aktivieren, um Stacktraces auf Fehlerseiten anzuzeigen oder wenn Cache-Dateien bei jeder Anfrage dynamisch neu erstellt werden sollen',
    'Enabled' => 'Aktiviert',
    'Enabled only' => 'Nur aktivieren',
    'Enabling sales for an event date does not affect the tickets individual sale status' => 'Die Aktivierung des Verkaufs für ein Veranstaltungsdatum hat keinen Einfluss auf den Einzelverkaufsstatus der Tickets',
    'Encryption' => 'Verschlüsselung',
    'End date' => 'Enddatum',
    'Ends On' => 'Endet am',
    'Enlarge' => 'Vergrößern',
    'Enter the chosen primary color code (i.e #ffffff)' => 'Geben Sie den gewählten Primärfarbcode ein (z. B. #ffffff)',
    'Enter the chosen website name with no spaces and no uppercase characters (for SEO purposes)' => 'Geben Sie den gewählten Websitenamen ohne Leerzeichen und ohne Großbuchstaben ein (für SEO-Zwecke)',
    'Enter the email address to be reached for inquiries' => 'Geben Sie die E-Mail-Adresse ein, die für Rückfragen zu erreichen ist',
    'Enter the full website url' => 'Geben Sie die vollständige Website-URL einb',
    'Enter the list of artists that will perform in your event (press Enter after each entry)' => 'Geben Sie die Liste der Künstler ein, die bei Ihrer Veranstaltung auftreten werden (drücken Sie nach jedem Eintrag die Eingabetaste).',
    'Enter the phone number to be called for inquiries' => 'Geben Sie die Telefonnummer ein, die für Rückfragen angerufen werden soll',
    'Enter the website url without http nor https' => 'Geben Sie die Website-URL ohne http oder https ein',
    'Enter the website url without http nor https, Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Geben Sie die Website-URL ohne http oder https ein. Bitte stellen Sie sicher, dass Sie diesen Parameter auch in der .env-Datei im Stammordner des Projekts ändern, da dies in einigen externen Paketen erforderlich ist',
    'Error' => 'Error',
    'Event' => 'Veranstaltung',
    'Event / Ticket' => 'Event / Ticket',
    'Event Categories' => 'Veranstaltungskategorien',
    'Event already started' => 'Veranstaltung bereits gestartet',
    'Event categories' => 'Veranstaltungskategorien',
    'Event date' => 'Veranstaltungsdatum',
    'Event date is disabled' => 'Veranstaltungsdatum ist deaktiviert',
    'Event dates' => 'Veranstaltungsdatum',
    'Event details' => 'Veranstaltungsdetails',
    'Event is not published' => 'El evento no está publicado',
    'Event list' => 'Veranstaltungsliste',
    'Event ticket' => 'Veranstaltungsticket',
    'Event ticket is disabled' => 'Veranstaltungsticket ist deaktiviert',
    'Event tickets' => 'Veranstaltungsticket',
    'Event views' => 'Veranstaltungsaufrufe',
    'Events' => 'Veranstaltungen',
    'Events Pages' => 'Veranstaltungsseite',
    'Events RSS feed' => 'RSS Veranstaltungsfeed',
    'Events added' => 'Veranstaltung hinzugefügt',
    'Events count' => 'Anzahl der Veranstaltungen',
    'Events in %countryname%' => 'Veranstaltung in %countryname%',
    'Events list' => 'Veranstaltungsliste',
    'Events list page' => 'Seite mit Veranstaltungen',
    'Events list page settings' => 'Einstellungen der Veranstaltungsliste',
    'Events on sale' => 'Veranstaltungen für den Verkauf',
    'Events page' => 'Veranstaltungsseite',
    'Events slider' => 'Veranstaltungsslider',
    'Events summary' => 'Zusammenfassung der Veranstaltungen',
    'Execute Symfony commands' => 'Ausführen von Symfony-Befehlen',
    'Execute command' => 'Befehl ausführen',
    'Execute this command after editing a file in the application source code or after modifying a string in the translations files' => 'Führen Sie diesen Befehl aus, nachdem Sie eine Datei im Quellcode der Anwendung bearbeitet oder eine Zeichenfolge in den Übersetzungsdateien geändert haben.',
    'Execute this command if you are in the development mode and the modifications you applied in the application did take effect' => 'Führen Sie diesen Befehl aus, wenn Sie sich im Entwicklungsmodus befinden und Ihre Anwendungsänderungen wirksam machen wollen',
    'Export attendees list to a PDF file' => 'Exportieren Sie die Teilnehmerliste in eine PDF-Datei',
    'Export current orders to a CSV file' => 'Aktuelle Bestellungen in eine CSV-Datei exportieren',
    'Export current orders to an Excel file' => 'Aktuelle Bestellungen in eine Excel-Datei exportieren',
    'External link' => 'Externer Link',
    'FAQ' => 'FAQ',
    'Facebook' => 'Facebook',
    'Facebook Id' => 'Facebook Id',
    'Facebook Secret' => 'Facebook Secret',
    'Facebook app id' => 'Facebook app id',
    'Facebook comments' => 'Facebook-Kommentare',
    'Facebook profile picture' => 'Facebook Profilbild',
    'Facebook url' => 'Facebook url',
    'Failed' => 'Gescheitert',
    'Favicon' => 'Favicon',
    'Favorites' => 'Favoriten',
    'Fax' => 'Fax',
    'Featured' => 'Hervorgehoben',
    'Featured categories' => 'Beliebte Kategorien',
    'Featured only' => 'Nur vorgestellt',
    'Featured order' => 'Empfohlene Bestellung',
    'Fees' => 'Gebühren',
    'First Name' => 'Vorname',
    'First name' => 'Vorname',
    'Flag' => 'Fahne',
    'Fluid' => 'Flüssig',
    'Follow' => 'Folgen',
    'Followed by' => 'gefolgt von',
    'Followers' => 'Followers',
    'Following' => 'Folgen',
    'Food and beverage' => 'Speisen und Getränke',
    'Food and beverage details' => 'Details zu Speisen und Getränken',
    'For \'Cash / Check / Bank Transfer / Other\', the order will remain on the \'Awaiting payment\' status until the organizer or the administrator approves it' => 'Bei „Bar/Scheck/Banküberweisung/Sonstiges“ bleibt die Bestellung im Status „Warten auf Zahlung“, bis der Organisator oder der Administrator sie genehmigt',
    'Forbidden' => 'Untersagt',
    'Forgot your password ?' => 'Passwort vergessen ?',
    'Free' => 'Gratis',
    'Free events only' => 'Nur kostenlose Veranstaltungen',
    'From date' => 'Anfangsdatum',
    'Full name' => 'Voller Name',
    'GDPR compliance' => 'DSGVO-Konformität',
    'Gallery' => 'Gellerie',
    'Gallery image' => 'Galleriebild',
    'Gdpr compliance page slug' => 'Seitenslug zur DSGVO-Compliance',
    'Gender' => 'Geschlecht',
    'General information' => 'Allgemeine Information',
    'Generation date' => 'Erstellungsdatum',
    'Global payment settings' => 'Globale Zahlungseinstellungen',
    'Gmail' => 'Gmail',
    'Go back' => 'zurück',
    'Go to the Pages section in the settings to add a new page' => 'Gehen Sie in den Einstellungen zum Abschnitt Seiten, um eine neue Seite hinzuzufügen',
    'Go to the documentation to get help about getting a list id' => 'Rufen Sie die Dokumentation auf, um Hilfe zum Abrufen einer Listen-ID zu erhalten',
    'Go to the documentation to get help about getting an api key' => 'In der Dokumentation finden Sie Hilfe zum Abrufen eines API-Schlüssels',
    'Go to the documentation to get help about getting an app ID' => 'Rufen Sie die Dokumentation auf, um Hilfe zum Abrufen einer App-ID zu erhalten',
    'Go to the documentation to get help about setting up Disqus' => 'Hilfe zur Konfiguration von Disqus finden Sie in der Dokumentation',
    'Google Id' => 'Google Id',
    'Google Maps' => 'Google Maps',
    'Google Maps Api Key' => 'Google Maps Api Key',
    'Google Maps settings' => 'Google Maps-Einstellungen',
    'Google Plus' => 'Google Plus',
    'Google Recaptcha' => 'Google Recaptcha',
    'Google Recaptcha settings' => 'Einstellungen für Google Recaptcha',
    'Google Secret' => 'Google Secret',
    'Google analytics Tracking ID' => 'Google analytics Tracking ID',
    'Google plus' => 'Google plus',
    'Green' => 'Grün',
    'Gross Sales' => 'Bruttoumsatz',
    'Gross sales' => 'Bruttoumsatz',
    'Gross sales by channel' => 'Bruttoumsatz nach Kanal',
    'Gross sales per Point of sale' => 'Bruttoumsatz nach Verkaufsstellen',
    'Guests' => 'Gäste',
    'Header' => 'Header',
    'Header text' => 'Headertext',
    'Help Center Article' => 'Hilfe Center Artikel',
    'Help Center Category' => 'Hilfe Center Kategorie',
    'Help Center Pages' => 'Hilfe Center Seiten',
    'Help Center page' => 'Hilfe Center Serite',
    'Help center' => 'Hilfe Center',
    'Here are the details' => 'Hier sind die Details',
    'Hey' => 'Hey',
    'Hidden' => 'Versteckt',
    'Hidden only' => 'Nur versteckt',
    'Hide' => 'Verstecken',
    'Hide from public directory' => 'Aus offentlichem Verzeichnis ausblenden',
    'Hide slider' => 'Verstecke Slider',
    'Homepage' => 'Homepage',
    'Homepage settings' => 'Homepageeinstellungen',
    'Host' => 'Host',
    'How can we help?' => 'Wie können wir helfen?',
    'Icon' => 'Icon',
    'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M' => 'Wenn Sie ein Youtube-Video haben, das Ihre Veranstaltung darstellt, fügen Sie es bitte im Standardformat hinzu: https://www.youtube.com/watch?v=FzG4uDgje3M',
    'If you need to send the confirmation email to a different email address, you can change it before submitting' => 'Wenn Sie die Bestätigungs-E-Mail an eine andere E-Mail-Adresse senden müssen, können Sie sie vor dem Senden ändern.',
    'If your event has a dedicated website, enter its url here' => 'Wenn Ihre Veranstaltung eine eigene Website hat, geben Sie hier Ihre URL ein',
    'If your event is a movie for example, select the available subtitles' => 'Wenn Ihre Veranstaltung beispielsweise ein Film ist, wählen Sie die verfügbaren Untertitel aus',
    'If your event is a movie for example, select the year of release' => 'Wenn Ihre Veranstaltung beispielsweise ein Film ist, wählen Sie das Erscheinungsjahr aus.',
    'Image' => 'Bild',
    'Images' => 'Bilder',
    'Images gallery' => 'Bildergallerie',
    'Impersonate' => 'Anmelden als',
    'In' => 'Auf',
    'In deinen Gedanken' => 'In deinen Gedanken',
    'Information not provided' => 'Keine Angaben gemacht',
    'Information provided' => 'Angaben gemacht ',
    'Inhalt' => 'Inhalt',
    'Instagram' => 'Instagram',
    'Instagram url' => 'Instagram url',
    'Instrucciones' => 'Instrucciones',
    'Instructions' => 'Anweisungen',
    'Instruções' => 'Instruções',
    'Invalid credentials' => 'Ungültige Zugangsdaten',
    'Is featured' => 'Ist gefeatured',
    'Is featured on the homepage slider?' => 'Wird es im Slider auf der Startseite angezeigt?',
    'Is this event date online ?' => 'Ist der Veranstaltungstermin online?',
    'Is this ticket free ?' => 'Ist dieses Ticket kostenlos?',
    'Keyword' => 'Schlüsselwort',
    'Language' => 'Sprache',
    'Language code' => 'Sprachcode',
    'Languages' => 'Sprache',
    'Last Name' => 'Nachname',
    'Last login' => 'letzter Login',
    'Last name' => 'Nachname',
    'Last updated' => 'letztes Update',
    'Lastest blog posts' => 'letzter Blog Post',
    'Layout settings' => 'Layout Einstellungen',
    'Layout, parameters and SEO' => 'Design, Parameter und SEO',
    'Leave a review' => 'Hinterlasse eine Bewertung',
    'Leave api key empty to disable google maps project wide' => 'Lassen Sie den API-Schlüssel leer, um das Google Maps-Projekt im gesamten Projekt zu deaktivieren',
    'Leave the password empty to keep the old one' => 'Lassen Sie das Passwort leer, um das alte zu behalten',
    'Left' => 'Links',
    'Let the other attendee know more details about your experience' => 'Lassen Sie das Passwort lesen, um das alte zu behalten',
    'Light blue' => 'Hellblau',
    'Link' => 'Link',
    'Link Text' => 'Link Text',
    'Link text' => 'Linktext',
    'LinkedIn' => 'LinkedIn',
    'Linkedin' => 'Linkedin',
    'List on public directory' => 'Im öffentlichen Verzeichnis aufgelistet',
    'Listed on directory' => 'Im Verzeichnis gelistet',
    'Listed on the directory' => 'Im Verzeichnis gelistet',
    'Local events only' => 'Nur loale Events',
    'Location' => 'Veranstaltungsort',
    'Locked (Payout request approved)' => 'Gesperrt (Zahlungsanforderung genehmigt)',
    'Locked (Payout request pending)' => 'Gesperrt (Zahlungsanforderung ausstehend)',
    'Login' => 'Login',
    'Logo' => 'Logo',
    'Looking for' => 'Suche',
    'Mail server' => 'Meil Server',
    'Mail server settings' => 'Mail Server Einstellungen',
    'Mail server test email' => 'Mail server test email',
    'Mailchimp app id' => 'Mailchimp app id',
    'Mailchimp list id' => 'Mailchimp list id',
    'Main blog post image' => 'Bild des Hauptblogbeitrags',
    'Main categories' => 'Hauptkategorie',
    'Main event image' => 'Hauptveranstaltungsfoto',
    'Main image' => 'Hauptfoto',
    'Maintenance mode' => 'Wartungsmodus',
    'Maintenance mode custom message' => 'Benutzerdefinierte Meldung im Wartungsmodus',
    'Make sure that the added payment gateways are configured to support this currency' => 'Stellen Sie sicher, dass die hinzugefügten Zahlungsgateways so konfiguriert sind, dass sie diese Währung unterstützen',
    'Make sure that the currency setting of your payout method matches the one currently used which is %currency%' => '
                    Stellen Sie sicher, dass die Währungseinstellung Ihrer Zahlungsmethode mit der aktuell verwendeten übereinstimmt, d. h. %currency%',
    'Make sure to select organizers who have added a cover photo' => 'Achten Sie darauf, Organisatoren auszuwählen, die ein Titelbild hinzugefügt haben',
    'Make sure to select right category to let the users find it quickly' => 'Stellen Sie sicher, dass Sie die richtige Kategorie auswählen, damit Benutzer sie schnell finden können',
    'Manage amenities' => 'Dienste verwalten',
    'Manage attendees' => 'Gäste verwalten',
    'Manage audiences' => 'Administratoren verwalten',
    'Manage blog post categories' => 'Blog Post Kategorien verwalten ',
    'Manage blog posts' => 'Blog Posts verwalten',
    'Manage categories' => 'Kategorien verwalten',
    'Manage countries' => 'Länder verwalten',
    'Manage currencies' => 'Währungen verwalten',
    'Manage event' => 'Veranstaltung verwalten',
    'Manage events' => 'Veranstaltungen verwalten',
    'Manage help center articles' => 'Help Center Artikel verwalten',
    'Manage help center categories' => 'Help Center Kategorien verwalten',
    'Manage languages' => 'Sprachen verwalten',
    'Manage menus' => 'Menüs verwalten',
    'Manage orders' => 'Buchungen verwalten',
    'Manage pages' => 'Seiten verwalten',
    'Manage reviews' => 'Bewertungen verwalten',
    'Manage users' => 'Benutzer verwalten',
    'Manage venues' => 'Veranstaltungsorte verwalten',
    'Manage venues types' => 'Veranstaltungsortkategorien verwalten',
    'Mark as featured' => 'Als hervorgehoben markieren',
    'Mark as not featured' => 'Als nicht hervorgehoben markieren',
    'Max' => 'Max',
    'Member since' => 'Mitglied seit',
    'Menu elements' => 'Menüelemente',
    'Menu name' => 'Menüname',
    'Menus' => 'Menüs',
    'Menus settings' => 'Menüeinstellungen',
    'Menüname' => 'Menüname',
    'Message' => 'Nachricht',
    'Method Not Supported' => 'Methode nicht unterstützt',
    'Min' => 'Min',
    'More details' => 'Mehr Details',
    'More information' => 'Mehr Informationen',
    'Mots clés' => 'Schlüsselwörter',
    'My cart' => 'Mein Warenkorb',
    'My events' => 'Meine Veranstaltungen ',
    'My favorites' => 'Meine Favoriten',
    'My orders' => 'Meine Bestellungen',
    'My organizer profile' => 'Mein Veranstaltungsprofil',
    'My points of sale' => 'Meine Verkaufsstellen',
    'My review' => 'Meine Bewertung',
    'My reviews' => 'Meine Bewertungen',
    'My scanners' => 'Meine Scanner',
    'My tickets' => 'Meine Tickets',
    'My venues' => 'Meine Veranstaltungsorte',
    'N/A' => 'N/A',
    'Na sua mente' => 'Na sua mente',
    'Name' => 'Name',
    'Name / Username' => 'Nsme / Benutzername',
    'Neighborhoods' => 'Nachbarn',
    'Net sales' => 'Nettoumsatz',
    'Net sales until' => 'Nettoumsatz bis',
    'New' => 'Neu',
    'New message regarding the order' => 'Neue Nachricht bezüglich der Bestellung',
    'New payout request' => 'Neue Auszahlungsanfrage',
    'New quote request' => 'Neue Angebotsanfrage',
    'Newsletter' => 'Newsletter',
    'Newsletter settings' => 'Newsletter Einstellungen',
    'Next month' => 'Nächster Monat',
    'Next week' => 'Nächste Woche',
    'No' => 'Nein',
    'No amenites found' => 'Keine Annehmlichkeiten gefunden',
    'No articles found' => 'Keine Artikel gefunden',
    'No attendees found' => 'Keine Gäste gefunden',
    'No audiences found' => 'Keine Zielgruppen gefunden',
    'No blog post categories found' => 'Keine Blog Post Kategorien gefunden',
    'No blog posts found' => 'Keine Blog Posts gefunden',
    'No categories found' => 'Keine Kategorien gefunden',
    'No countries found' => 'Keine Länder gefunden',
    'No currencies found' => 'Keine Währung gefunden',
    'No event dates found' => 'Kein Veranstaltungsdatum gefunden',
    'No events found' => 'Keine Veranstaltung gefunden',
    'No events on sale' => 'Keine Veranstaltungen im Verkauf',
    'No events on sale for now' => 'Momentan stehen keine Events zum Verkauf',
    'No languages found' => 'Keine Sprachen gefunden',
    'No link, display featured categories dropdown on hover (header menu only)' => 'Kein Link, Dropdown-Menü für vorgestellte Kategorien bei Mouseover anzeigen (nur Kopfzeilenmenü)',
    'No menus found' => 'Keine Menüs gefunden',
    'No orders found' => 'keine Verkäufe gefunden',
    'No orders found to be included in the report' => 'Es wurden keine Anfragen gefunden, die in den Bericht aufgenommen wurden',
    'No pages found' => 'Keine Seiten gefunden',
    'No past events found' => 'Keine vergangene Veranstaltung gefunden',
    'No payment gateways are currently enabled' => 'Derzeit sind keine Zahlungsgateways aktiviert',
    'No payment gateways found' => 'Keine Zahlungsgateways gefunden',
    'No payout requests found' => 'Keine Zahlungsaufforderungen gefunden',
    'No points of sale found' => 'Keine Verkaufsstellen gefunden',
    'No reply email address' => 'Keine Antwort E-Mail Adresse',
    'No review found' => 'Keine Bewertungen gefunden',
    'No reviews found' => 'Keine Bewertungen gefunden',
    'No sales yet' => 'Noch kein Verkauf',
    'No scanners found' => 'Keine Scanner gefunden',
    'No ticket on sale' => 'keine Tickets im Verkauf',
    'No tickets selected to add to cart' => 'Es wurden keine Tickets zum Warenkorb hinzugefügt',
    'No users found' => 'Keine Benutzer gefunden',
    'No venue types found' => 'Keine Veranstaltungsortkategorie gefunden',
    'No venues found' => 'Keine Veranstaltungsorte gefunden',
    'Nom' => 'Name',
    'Nom du menu' => 'Menüname',
    'Nombre' => 'Nummer',
    'Nombre du menú' => 'Anzahl der Menüs',
    'Nome' => 'Nome',
    'Nome do menu' => 'Nome do menu',
    'None' => 'Nicht',
    'Not Checked In Only' => 'noch nicht registriert',
    'Not a member yet ?' => 'Noch kein Mitglied?',
    'Not elapsed only' => 'Nicht alleine verbracht',
    'Not featured' => 'Nicht vorgestellt',
    'Not listed on the directory' => 'Nicht im Verzeichnis enthalten',
    'Note' => 'Notiz',
    'Number of blog posts per page' => 'Anzahl Blogbeiträge pro Seite',
    'Number of blog posts to show' => 'Anzahl der anzuzeigenden Blogbeiträge',
    'Number of events per page' => 'Anzahl der Veranstaltungen pro Seite',
    'Number of events to show' => 'Anzahl der anzuzeigenden Veranstaltungen',
    'Number of featured categories to show' => 'Anzahl der angezeigten Kategorien, die angezeigt werden sollen',
    'Number of guests' => 'Antahl der Gäste',
    'Number of seconds before the reserved tickets are released if the order is still awaiting payment' => 'Anzahl der Sekunden, bevor reservierte Tickets freigegeben werden, wenn die Zahlung noch aussteht',
    'Number of tickets' => 'Antahl der Tickets',
    'OR' => 'oder',
    'On sale' => 'Im Varkauf',
    'Once the payout request submitted, the event date will be locked and the sales will be suspended for the specific event date. If you wish, you can wait until the start date of the event date before requesting the payout. You can cancel the payout request any time before it is processed' => 'Nach Übermittlung der Zahlungsaufforderung wird das Veranstaltungsdatum gesperrt und der Verkauf für das jeweilige Veranstaltungsdatum ausgesetzt. Wenn Sie möchten, können Sie bis zum Startdatum der Veranstaltung warten, bevor Sie die Zahlung anfordern. Sie können die Zahlungsanforderung jederzeit vor der Bearbeitung stornieren',
    'Online' => 'Online',
    'Online events only' => 'Nur Online Veranstaltung',
    'Optional attendee information' => 'Optionale Informationen für Teilnehmer',
    'Optionally add a cover photo to showcase your organizer activities' => 'Fügen Sie optional ein Titelbild hinzu, um Ihre Organisatorenaktivitäten zu zeigen',
    'Orange' => 'Orange',
    'Order' => 'Bestellung',
    'Order =' => 'Bestellung',
    'Order = ' => 'Bestellung =',
    'Order Date' => 'Bestelldatum',
    'Order confirmation' => 'Bestellbestätigung',
    'Order date' => 'Bestelldatum',
    'Order details' => 'Bestelldetails',
    'Order of appearance' => 'Bestellungsreihenfolge',
    'Order payment details' => 'Zahlungsdetails zur Bestellung',
    'Order reference' => 'Bestellnummer',
    'Order status' => 'Bestellstatus',
    'Order summary' => 'Bestellübersicht',
    'Order total' => 'Bestellsumme',
    'Orders' => 'Bestellungen',
    'Orders placed' => 'Bestellungen aufgegeben',
    'Orders summary' => 'Bestellübersicht',
    'Organizer' => 'Veranstalter',
    'Organizer / Event / Date / Ticket' => 'Veranstalter / Veranstaltung / Datum / Ticket',
    'Organizer Profile' => 'Veranstaltungsprofil',
    'Organizer Registration' => 'Veranstalterregistrierung',
    'Organizer information' => 'Informationen zum Veranstalter',
    'Organizer is disabled' => 'Der Veranstalter ist deaktiviert',
    'Organizer logo' => 'Veranstalterlogo',
    'Organizer name' => 'Veranstaltername',
    'Organizer profile' => 'Veranstalterprofil',
    'Organizer revenue from %website_name%' => 'Einnahmen des Veranstalters aus %website_name%',
    'Organizers' => 'Veranstalter',
    'Organizers Pages' => 'Veranstalterseite',
    'Organizers slider' => 'Veranstalterslider',
    'Organizers, attendees, this support center is intended to quickly reply to your questions, if still don\'t find answers, please contact us, w e will be happy to receive your inquiry' => 'Organisatoren, Teilnehmer, dieses Support-Center soll Ihre Fragen schnell beantworten, sollten Sie die Antworten dennoch nicht finden, kontaktieren Sie uns bitte, wir freuen uns über Ihre Anfrage.',
    'Other events by %organizername%' => 'Andere Veranstaltungen von %organizername%',
    'PERMANENTLY' => 'PERMANENT',
    'POS' => 'Kasse',
    'Page content' => 'Seiteninhalt',
    'Page not found' => 'Seite nicht gefunden',
    'Pages' => 'Seiten',
    'Paid' => 'Bezahlt',
    'Paid orders' => 'Bezahlte Bestellungen',
    'Palabras clave' => 'Schlüsselwörter',
    'Palavras-chave' => 'Palavras-chave',
    'Paragraph' => 'Absatz',
    'Paragraphe' => 'Absatz',
    'Parágrafo' => 'Parágrafo',
    'Password' => 'Passwort',
    'Password Resetting' => 'Passwort zurücksetzen',
    'Past events' => 'Vergangene Veranstaltungen',
    'Pay now' => 'Jetzt bezahlen',
    'Payment' => 'Zahlung',
    'Payment details' => 'Zahlungsdetails',
    'Payment gateways' => 'Zahlungsgateways',
    'Payment method' => 'Zahlungsmethode',
    'Payment of tickets purchased on %website_name%' => 'Zahlung von Tickets, die bei %website_name% gekauft wurden',
    'Payment settings' => 'Zahlungseinstellungen',
    'Payments and Fees' => 'Zahlungen und Gebühren',
    'Payout already requested' => 'Auszahlung bereits angefordert',
    'Payout method' => 'Auszahlungsmethode',
    'Payout methods' => 'Auszahlungsmethoden',
    'Payout request' => 'Zahlungsanforderung',
    'Payout request details' => 'Details zur Zahlungsanforderung',
    'Payout request notification' => 'Benachrichtigung über Zahlungsanforderung',
    'Payout request payment details' => 'Zahlungsdetails der Zahlungsaufforderung',
    'Payout requests' => 'Zahlungsanforderungen',
    'Payouts' => 'Auszahlungen',
    'Paypal Client Id' => 'Paypal Client Id',
    'Paypal Client Secret' => 'Paypal Client Secret',
    'Paypal Express Checkout' => 'Paypal Express Checkout',
    'Pending' => 'Ausstehend',
    'Pending payout requests' => 'Austehende Zahlungsanforderungen',
    'Percentage cut' => 'Prozentualer Schnitt',
    'Phone' => 'Telefon',
    'Phone number' => 'Telefonnummer',
    'Photos' => 'Fotos',
    'Pick a date' => 'Wähle ein Datum',
    'Pink' => 'Pink',
    'Please choose a 200x200 minimum image size as it is required by Facebook' => 'Wählen Sie eine Mindestbildgröße von 200 x 200, wie von Facebook gefordert',
    'Please choose a 200x50 image size to ensure compatibility with the website design' => 'Wählen Sie eine Bildgröße von 200 x 50, um die Kompatibilität mit Ihrem Website-Design sicherzustellen.',
    'Please click on the following link to check the status of your request' => 'Klicken Sie auf den folgenden Link, um den Status Ihrer Bewerbung zu überprüfen',
    'Please confirm your account by clicking the link below' => 'Bestätigen Sie Ihr Konto, indem Sie auf den untenstehenden Link klicken',
    'Please enter the selected payment gateway details' => 'Geben Sie die Details des ausgewählten Zahlungsgateways ein',
    'Please enter your payout method details' => 'Geben Sie die Details Ihrer Zahlungsmethode ein',
    'Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Stellen Sie sicher, dass Sie diesen Parameter auch in der .env-Datei im Projektstammordner ändern, da dies in einigen externen Paketen erforderlich ist',
    'Please refer to this following list and use the Code column: https://en.wikipedia.org/wiki/ISO_4217' => 'Sehen Sie sich die folgende Liste an und verwenden Sie die Spalte Code: https://en.wikipedia.org/wiki/ISO_4217',
    'Please set a payout method before submitting a payout request' => 'Richten Sie eine Zahlungsmethode ein, bevor Sie eine Zahlungsanfrage senden',
    'Please wait a few seconds if the translation interface freezes at page load, or edit the files in translations/ folder at root of the project directly in your favorite text editor' => 'Warten Sie einige Sekunden, wenn die Übersetzungsoberfläche beim Laden der Seite einfriert, oder bearbeiten Sie die Dateien in den Übersetzungen / Ordnern im Stammverzeichnis des Projekts direkt in Ihrem bevorzugten Texteditor',
    'Point of sale' => 'Verkaufsstelle',
    'Point of sale information' => 'Informationen zur Verkaufsstelle',
    'Point of sales' => 'Verkaufstellen',
    'Points of sale' => 'Verkaufsstellen',
    'Popular' => 'Beliebt',
    'Popularity' => 'Beliebtheit',
    'Port' => 'Port',
    'Position' => 'Position',
    'Postal code' => 'Postleitzahl',
    'Posts' => 'Beiträge',
    'Price' => 'Preis',
    'Pricing' => 'Preise',
    'Primary color code' => 'Hauptfarbcode',
    'Print tickets' => 'Tickets drucken',
    'Privacy policy' => 'Datenschutzerklärung',
    'Privacy policy page slug' => 'Datenschutzrichtlinie Slug Seite',
    'Processed' => 'Verarbeitet',
    'Processed at' => 'Verarbeitet am',
    'Processing date' => 'Verarbeitungsdatum',
    'Production' => 'Produktion',
    'Profile picture' => 'Profilbild',
    'Profile views' => 'Profilaufrufe',
    'Project wide date and time format, follow this link for a list of supported characters: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string' => 'Projektweites Datums- und Uhrzeitformat, folgen Sie diesem Link für eine Liste der unterstützten Zeichen: https://unicode-org.github.io/icu/userguide/format_parse/datetime/. Bitte achten Sie darauf, die doppelten Anführungszeichen "" um die Formatzeichenfolge zu halten',
    'Promotional price' => 'Aktionspreis',
    'Publicly show attendees' => 'Den Teilnehmern öffentlich anzeigen',
    'Publish' => 'Veröffentlichen',
    'Published events' => 'Veröffentlichte Veranstaltungen',
    'Published only' => 'Gerade veröffentlicht',
    'Purple' => 'Lila',
    'Párrafo' => 'Absatz',
    'Quantity' => 'Menge',
    'Rating' => 'Rating',
    'Read time in minutes' => 'Lesezeit in Minuten',
    'Recent orders' => 'letzte Bestellungen',
    'Red' => 'Rot',
    'Reference' => 'Referenz',
    'Register' => 'Register',
    'Register attendees' => 'Teilnehmer registrieren',
    'Registered using Facebook' => 'Registriert über Facebook',
    'Registered using Google' => 'Registriert über Google',
    'Registration date' => 'Registrierungsdatum',
    'Related posts' => 'Zusammenhängende Beiträge',
    'Remove' => 'Entfernen',
    'Remove from favorites' => 'Von den Favoriten entfernen',
    'Repeat password' => 'Passwort wiederholden',
    'Reports' => 'Report',
    'Request a quote' => 'Fordern Sie ein Angebot an',
    'Request date' => 'Angebotsdatum',
    'Request payout' => 'Zahlungsaufforderung',
    'Requested at' => 'Angefordert am',
    'Resend confirmation email' => 'Bestätigungsmail erneut senden',
    'Reset' => 'Zurücksetzen',
    'Reset your password' => 'Passwort zurücksetzen',
    'Response' => 'Antworten',
    'Restore' => 'Wiederherstellen',
    'Review date' => 'Prüfungsdatum',
    'Review(s)' => 'Bewertung(en)',
    'Reviews' => 'Bewertungen',
    'Reviews for %eventname%' => 'Bewertungen für %eventname%',
    'Right' => 'Rechts',
    'Role' => 'Rolle',
    'SEO keywords' => 'SEO-Keywords',
    'SMTP' => 'SMTP',
    'SSL' => 'SSL',
    'SSL must be activated on your hosting server in order to use Mailchimp' => 'SSL muss auf deinem Hosting-Server aktiviert sein, um Mailchimp nutzen zu können',
    'Sale didn\'t start yet' => 'Der Verkauf hat noch nicht begonnen',
    'Sale ended' => 'Verkauf endet',
    'Sale ends On' => 'Verkauf endet am',
    'Sale starts On' => 'Verkauf startet um',
    'Sales' => 'Verkauf',
    'Sales channel' => 'Verkaufskanal',
    'Sales end' => 'Verkaufsstop',
    'Sales end date' => 'Ende des Verkaufs',
    'Sales end in' => 'Verkauf endet in',
    'Sales ended' => 'Verkauf beendet',
    'Sales ended on' => 'Verkauf endet am',
    'Sales start date' => 'Verkaufsstartdatum',
    'Sales start in' => 'Verkauf startet in',
    'Sales started' => 'Verkauf startet',
    'Sales started on' => 'Verkauf startet am',
    'Sandbox' => 'Sandbox',
    'Save' => 'Speichern',
    'Save order' => 'Bestellung speichern',
    'Scanned tickets' => 'Gescannte Tickets',
    'Scanner' => 'Scanner',
    'Scanner App' => 'Scanner App',
    'Scanner App settings' => 'Scanner App Einstellungen',
    'Scanner information' => 'Scanner Informationen',
    'Scanners' => 'Scanner',
    'Schlüsselwörter' => 'Schlüsselwörter',
    'Search' => 'Suchen',
    'Search blog' => 'Den Blog durchsuchen',
    'Search blog posts' => 'Blogbeiträge durchsuchen',
    'Search for answers' => 'Nach Antworten suchen',
    'Search for events' => 'Nach Veranstaltungen suchen',
    'Search help center' => 'Help Center durchsuchen',
    'Search in reviews' => 'Suche in Bewertungen',
    'Seated' => 'Bestuhlt',
    'Seated guests' => 'Sitzende Gäste',
    'Seated guests number' => 'Sitznummer der Gäste',
    'Secret key' => 'Geheimschlüssel',
    'See all' => 'Alles ansehen',
    'See all %reviewscount% reviews' => 'Sieh alle %reviewscount% Bewertungen',
    'See all events on sale' => 'Alle angebotenen Veranstaltungen ansehen',
    'See more articles' => 'Weitere Artikel anzeigen',
    'Select a payout method' => 'Wählen Sie eine Zahlungsmethode',
    'Select a specific event date' => 'Wählen Sie ein bestimmtes Veranstaltungsdatum aus',
    'Select a specific event ticket' => 'Wählen Sie ein bestimmtes Veranstaltungsticket',
    'Select an option' => 'Wähle eine Option',
    'Select parent of \'Point of sale\' or \'Scanner\'' => 'Wählen Sie das übergeordnete Element von "Point of Sale" oder "Scanner" aus.',
    'Select the audience types that are targeted in your event' => 'Wählen Sie die Zielgruppentypen aus, auf die Ihre Veranstaltung ausgerichtet ist',
    'Select the categories that represent your events types' => 'Wählen Sie die Kategorien aus, die Ihre Veranstaltungstypen repräsentieren',
    'Select the country that your event represents (ie: A movie\'s country of production)' => 'Wählen Sie das Land aus, das Ihre Veranstaltung repräsentiert (d. h. das Produktionsland eines Films).',
    'Select the languages that will be spoken in your event' => 'Wählen Sie die Sprachen aus, die bei Ihrer Veranstaltung gesprochen werden sollen',
    'Select the parent category to add a sub category' => 'Wählen Sie die Hauptkategorie aus, um eine Unterkategorie hinzuzufügen',
    'Send' => 'Senden',
    'Send us an email' => 'Sende uns eine E-Mail',
    'Sendmail' => 'Absenden',
    'Set' => 'Definieren',
    'Set a new password' => 'Setze ein neues Passwort',
    'Set a price lesser than than the original price to indicate a promotion (this price will be the SALE price)' => 'Legen Sie einen niedrigeren Preis als den Originalpreis fest, um eine Aktion anzuzeigen (dieser Preis ist der SALE-Preis).',
    'Set the display order for the featured categories' => 'Legen Sie die Anzeigereihenfolge der vorgestellten Kategorien fest',
    'Set the number of tickets that an attendee can buy for this ticket type' => 'Legen Sie die Anzahl der Tickets fest, die ein Teilnehmer für diesen Tickettyp kaufen kann',
    'Set your %payoutMethodName% payout method' => 'Legen Sie Ihre Zahlungsmethode fest %payoutMethodName%',
    'Settings' => 'Einstellungen',
    'Share' => 'Teilen',
    'Show' => 'Zeigen',
    'Show RSS feed button' => 'RSS Feed Schaltfläche anzeigen',
    'Show a map at the bottom of your organizer profile page containing the venues you added' => 'Zeigen Sie unten auf der Profilseite Ihres Organisators eine Karte an, die die Orte enthält, die Sie hinzugefügt haben',
    'Show audience filter' => 'Zielgruppenfilter anzeigen',
    'Show calendar button' => 'Kalender-Schaltfläche anzeigen',
    'Show category filter' => 'Kategoriefilter anzeigen',
    'Show date filter' => 'Datumsfilter anzeigen',
    'Show event date stats on the scanner app' => 'Ereignisdatenstatistiken in der Scanner-App anzeigen',
    'Show event dates and tickets' => 'Veranstaltungs- und Ticketdaten anzeigen',
    'Show events calendar' => 'Veranstaltungskalender anzeigen',
    'Show events on map' => 'Veranstaltungen auf der Karte anzeigen',
    'Show followers' => 'Follower anzeigen',
    'Show location filter' => 'Standortfilter anzeigen',
    'Show map button' => 'Schaltfläche Karte anzeigen',
    'Show reviews' => 'Bewertungen anzeigen',
    'Show the GDPR compliance page link' => 'Link zur DSGVO-Datenschuterklärung anzeigen',
    'Show the attendees number and list in the event page' => 'Zeigen Sie die Anzahl der Teilnehmer und die Liste auf der Veranstaltungsseite an.',
    'Show the back to top button' => 'Zurück zum Anfangs-Button anzeigen',
    'Show the call to action block' => 'Call-to-Action-Block anzeigen',
    'Show the cookie policy bar at the bottom' => 'Zeigen Sie unten die Cookie-Richtlinienleiste an.',
    'Show the cookie policy page link' => 'Zeigen Sie den Link zur Seite mit den Cookie-Richtlinien an',
    'Show the homepage hero seach box' => 'Hero-Suchfeld der Startseite anzeigen',
    'Show the map along with the address on the venue page and event page' => 'Karte zusammen mit Adresse auf der Veranstaltungs- und Veranstaltungsseite anzeigen',
    'Show the number and list of people that follow you' => 'Zeige die Nummer und die Liste der Personen, die dir folgen',
    'Show the privacy policy page link' => 'Link zur Datenschutzerklärung anzeigen',
    'Show the quote form on the venue page' => 'Zeigen Sie das Angebotsformular auf der Website-Seite an',
    'Show the reviews that you received for your events' => 'Zeigen Sie die Bewertungen an, die Sie von Ihren Veranstaltungen erhalten haben.',
    'Show the search box' => 'Suchfeld anzeigen',
    'Show the terms of service page link' => 'Link zur Seite mit den Nutzungsbedingungen anzeigen',
    'Show ticket price filter' => 'Ticketpreisfilter anzeigen',
    'Show tickets left count on cart modal' => 'Anzahl der verbleibenden Einträge im Warenkorb anzeigen',
    'Show venues map' => 'Standortplan anzeigen',
    'Sign in' => 'Einloggen',
    'Sign in via Facebook' => 'Einloggen via Facebook',
    'Sign in via Google' => 'Einloggen via Google',
    'Sign out' => 'Ausloggen',
    'Sign up' => 'Registrieren',
    'Sign up via Facebook' => 'über Facebook registrieren',
    'Sign up via Google' => 'Über Google registrieren',
    'Similar events' => 'Ähnliche Veranstaltungen',
    'Site key' => 'Seitenschlüssel',
    'Sitemap' => 'Sitemap',
    'Slug' => 'Slug',
    'Social Login' => 'Sovial Login',
    'Social Login settings' => 'Social Login Einstellungen',
    'Social media share image' => 'Bild in sozialen Netzwerken teilen',
    'Sold out' => 'Ausverkauft',
    'Sort by' => 'Sortiert von',
    'Standing' => 'Stehen',
    'Standing guests' => 'Stehende Gäste',
    'Standing guests number' => 'Standplatznummer',
    'Start date' => 'Startdatum',
    'Starts On' => 'Startet am',
    'State' => 'Bundesland',
    'State / City' => 'Bundesland / Stadt',
    'Static Pages' => 'Statische Seite',
    'Statistics' => 'Statistiken',
    'Status' => 'Status',
    'Still in cart' => 'Noch im Warenkorb',
    'Street' => 'Straße',
    'Street 2' => 'Straße 2',
    'Street address' => 'Adresse',
    'Street address 2' => 'Adresse 2',
    'Stripe Checkout' => 'Stripe Checkout',
    'Stripe Checkout (credit cards)' => 'Stripe Checkout (credit cards)',
    'Stripe payout' => 'Stripe Auszahlung',
    'Stripe publishable key' => 'Stripe publishable key',
    'Stripe secret key' => 'Stripe secret key',
    'Subject' => 'Subjekt',
    'Submit payment' => 'Zahlung ausführen',
    'Subscribe' => 'Abonieren',
    'Subscribe to our newsletter' => 'Unseren Newsletter abonieren',
    'Subtitles' => 'Untertitel',
    'Subtotal' => 'Zwischensumme',
    'Successfully executed the command' => 'Befehl erfolgreich ausgeführt',
    'Support for' => 'Unterstützung für',
    'Suspended' => 'Suspendiert',
    'Symbol' => 'Symbol',
    'TLS' => 'TLS',
    'TSL' => 'TSL',
    'Tags' => 'Tags',
    'Take your events to the next level' => 'Bringen Sie Ihre Veranstaltungen auf das nächste Level',
    'Tell your attendees more about this ticket type' => 'Erzählen Sie Ihren Teilnehmern mehr über diese Art von diesen Tickets',
    'Terms of service' => 'Nutzungsbedingungen',
    'Terms of service page slug' => 'Slug Seite mit den Nutzungsbedingungen',
    'Test the mail server configuration' => 'Test the mail server configuration',
    'Texte du lien' => 'Link Text',
    'Texto del enlace' => 'Link Text',
    'Texto do link' => 'Texto do link',
    'The amenity can not be deleted because it is linked with one or more venues' => 'Slug Seite mit den Nutzungsbedingungen',
    'The amenity can not be found' => 'Kann den Dienst nicht finden',
    'The amenity has been deleted' => 'Der Dienst wurden entfernt',
    'The amenity has been disabled' => 'Der Dienst wurde deaktiviert',
    'The amenity has been succesfully restored' => 'Der Dienst wurde erfolgreich wiederhergestellt',
    'The amenity has been successfully created' => 'Der Dienst wurde erfolgreich erstellt',
    'The amenity has been successfully updated' => 'Der Dienst wurde erfolgreich aktualisiert',
    'The amenity is hidden' => 'Der dienst ist versteckt',
    'The amenity is visible' => 'Der Dienst ist sichtbar',
    'The article can not be found' => 'Artikel kann nicht gefunden werden',
    'The article has been deleted' => 'Der Artikel wurde entfernt',
    'The article has been disabled' => 'Der Artikel wurde gelöscht',
    'The article has been succesfully restored' => 'Der Artikel wurde erfolgreich wiederhergestellt',
    'The article has been successfully created' => 'Der Artikel wurde erfolgreich erstellt',
    'The article has been successfully updated' => 'Der Artikel wurde erfolgreich aktualisiert.',
    'The article is featured' => 'Der Artikel ist hervorgehoben',
    'The article is hidden' => 'Der Artikel ist versteckt',
    'The article is not featured anymore' => 'Der Artikel ist nicht mehr hervorgehoben',
    'The article is visible' => 'Der Artikel ist sichtbar',
    'The article not be found' => 'Der Artikel kann nicht gefunden werden',
    'The audience can not be deleted because it is linked with one or more events' => 'Die Zielgruppe kann nicht gelöscht werden, da sie mit einem oder mehreren Ereignissen verknüpft ist',
    'The audience can not be found' => 'Die Zielgruppe kann nicht gefunden werden',
    'The audience has been deleted' => 'Die Zielgruppe wurde gelöscht',
    'The audience has been disabled' => 'Die Zielgruppe wurde deaktiviert',
    'The audience has been succesfully restored' => 'Die Zielgruppe wurde erfolgreich wiederhergestellt',
    'The audience has been successfully created' => 'Die Zielgruppe wurde erfolgreich erstellt',
    'The audience has been successfully updated' => 'Die Zielgruppe wurde erfolgreich aktualisiert',
    'The audience is hidden' => 'Die Zielgruppe ist versteckt',
    'The audience is visible' => 'Die Zielgruppe ist sichtbar',
    'The blog post can not be found' => 'Kann den Blogbeitrag nicht finden',
    'The blog post category can not be deleted because it is linked with one or more blog posts' => 'Die Blogbeitragskategorie kann nicht entfernt werden, da sie mit einem oder mehreren Blogbeiträgen verknüpft ist.',
    'The blog post category can not be found' => 'Kann die Kategorie für Blogbeiträge nicht finden',
    'The blog post category has been deleted' => 'Kategorie aus Blogbeitrag entfernt.',
    'The blog post category has been disabled' => 'Die Blogbeitragkategorie wurde deaktiviert.',
    'The blog post category has been succesfully restored' => 'Die Blogbeitragkategorie wurde erfolgreich wiederhergestellt',
    'The blog post category has been successfully created' => 'Die Blogbeitragkategorie wurde erfolgreich erstellt',
    'The blog post category has been successfully updated' => 'Die Blogbeitragkategorie wurde erfolgreich aktualisiert.',
    'The blog post category is hidden' => 'Die Blogbeitragkategorie ist ausgeblendet',
    'The blog post category is visible' => 'Die Kategorie des Blogbeitrags ist sichtbar',
    'The blog post has been deleted' => 'Der Blogbeitrag wurde entfernt.',
    'The blog post has been disabled' => 'Der Blogbeitrag wurde deaktiviert.',
    'The blog post has been succesfully restored' => 'Der Blogbeitrag wurde erfolgreich wiederhergestellt.',
    'The blog post has been successfully created' => 'Der Blogbeitrag wurde erfolgreich erstellt',
    'The blog post has been successfully updated' => 'Der Blogbeitrag wurde erfolgreich aktualisiert',
    'The blog post is hidden' => 'Der Blogbeitrag ist ausgeblendet',
    'The blog post is visible' => 'Der Blogbeitrag ist sichtbar',
    'The blog post not be found' => 'Der Blogbeitrag wurde nicht gefunden',
    'The category can not be deleted because it is linked with one or more events' => 'Die Kategorie kann nicht entfernt werden, da sie mit einem oder mehreren Ereignissen verknüpft ist',
    'The category can not be deleted because it is linked with one or more help center articles' => 'Die Kategorie kann nicht entfernt werden, da sie mit einem oder mehreren Hilfeartikeln verknüpft ist.',
    'The category can not be found' => 'Kategorie kann nicht gefunden werden',
    'The category has been deleted' => 'Kategorie wurde gelöscht',
    'The category has been disabled' => 'Kategorie wurde deaktiviert',
    'The category has been succesfully restored' => 'Kategorie wurde erfolgreich wiederhergestellt',
    'The category has been successfully created' => 'Kategorie wurde erfolgreich erstellt',
    'The category has been successfully updated' => 'Kategorie wurde erfolgreich aktualisiert',
    'The category is featured and is shown in the homepage categories' => 'Die Kategorie erscheint und wird in den Kategorien auf der Startseite angezeigt',
    'The category is hidden' => 'Die Kategorie ist ausgeblendet',
    'The category is not featured anymore and is removed from the homepage categories' => 'Kategorie wird nicht mehr angezeigt und aus den Kategorien der Startseite entfernt',
    'The category is visible' => 'Die Kategorie ist sichtbar',
    'The category not be found' => 'Kategorie kann nicht gefunden werden',
    'The confirmation email has been resent to' => 'Die Bestätigungs-E-Mail wurde weitergeleitet an',
    'The country can not be deleted because it is linked with one or more events' => 'Das Land kann nicht entfernt werden, da es mit einem oder mehreren Ereignissen verknüpft ist',
    'The country can not be found' => 'Land kann nicht gefunden werden',
    'The country has been deleted' => 'Das Land wurden entfernt',
    'The country has been disabled' => 'Das Land wurde deaktiviert',
    'The country has been succesfully restored' => 'Das Land wurde erfolgreich wiederhergestellt',
    'The country has been successfully created' => 'Das Land wurde erfolgreich erstellt',
    'The country has been successfully updated' => 'Das Land wurde erfolgreich aktualisiert.',
    'The country is hidden' => 'Das Land ist ausgeblendet',
    'The country is visible' => 'Das Land ist sichtbar',
    'The currency can not be found' => 'Die Währung kann nicht gefunden werden',
    'The currency has been deleted' => 'Die Währung wurden entfernt',
    'The currency has been successfully created' => 'Die Währung wurde erfolgreich erstellt',
    'The currency has been successfully updated' => 'Die Währung wurde erfolgreich aktualisiert.',
    'The default locale must be selected in the available languages' => 'Das Standardgebietsschema sollte in den verfügbaren Sprachen ausgewählt werden',
    'The email could not be sent' => 'The email could not be sent',
    'The event can not be deleted because it has one or more orders' => 'Die Veranstaltung kann nicht gelöscht werden, da es eine oder mehrere Bestellungen enthält',
    'The event can not be found' => 'Kann Die Veranstaltung nicht finden',
    'The event date can not be found' => 'Kann Die Veranstaltung nicht finden',
    'The event date stats (sales and attendance) will be visible on the scanner app' => 'Die Statistik des Veranstaltungsdatums (Verkauf und Anwesenheit) wird in der Scanner-Anwendung angezeigt',
    'The event has been added to your favorites' => 'Die Veranstaltung wurde zu Ihren Favoriten hinzugefügt',
    'The event has been deleted' => 'Die Veranstaltung wurde entfernt',
    'The event has been deleted permanently' => 'Die Veranstaltung wurde endgültig entfernt',
    'The event has been published and will figure in the search results' => 'Die Veranstaltung wurde veröffentlicht und erscheint in den Suchergebnissen.',
    'The event has been removed from your favorites' => 'Die Veranstaltung wurde zu Ihren Favoriten hinzugefügt',
    'The event has been succesfully restored' => 'Die Veranstaltung wurde erfolgreich wiederhergestellt',
    'The event has been successfully created' => 'Die Veranstaltung wurde erfolgreich erstellt',
    'The event has been successfully updated' => 'Die Veranstaltung wurde erfolgreich aktualisiert.',
    'The event has been unpublished and will not be included in the search results' => 'Die Veranstaltung wurde veröffentlicht und erscheint in den Suchergebnissen.',
    'The event not be found' => 'Kann die Veranstaltung nicht finden',
    'The event ticket can not be found' => 'Kann das Veranstaltungsticket nicht finden',
    'The fields preceded with a red * are mandatory' => 'Felder mit einem roten * sind Pflichtfelder',
    'The form contains invalid data' => 'Das Formular enthält ungültige Daten',
    'The homepage settings could not be loaded' => 'Fehler beim Laden der Startseiteneinstellungen',
    'The language can not be deleted because it is linked with one or more events' => 'Die Sprache kann nicht entfernt werden, da sie mit einem oder mehreren Ereignissen verknüpft ist',
    'The language can not be found' => 'Die Sprache kann nicht gefunden werden',
    'The language has been deleted' => 'Die Sprache wurden entfernt',
    'The language has been disabled' => 'Die Sprache wurde deaktiviert',
    'The language has been succesfully restored' => 'Die Sprache wurde erfolgreich wiederhergestellt',
    'The language has been successfully created' => 'Die Sprache wurde erfolgreich erstellt',
    'The language has been successfully updated' => 'Die Sprache wurde erfolgreich aktualisiert.',
    'The language is hidden' => 'Die Sprache ist versteckt',
    'The language is visible' => 'Die Sprache ist sichtbar',
    'The layout settings could not be loaded' => 'Layoutkonfiguration konnte nicht geladen werden',
    'The menu can not be found' => 'Das Menü konnte nicht gefunden werden',
    'The menu has been successfully updated' => 'Das Menü wurde erfolgreich aktualisiert.',
    'The order can not be found' => 'Die Bestellung konnte nicht gefunden werden',
    'The order has been deleted' => 'Die Bestellung wurde entfernt',
    'The order has been permanently canceled' => 'Die Bestellung wurde endgültig storniert',
    'The order has been permanently deleted' => 'Die Bestellung wurde endgültig storniert',
    'The order has been soft deleted, restore it before canceling it' => 'Bestellung wurde vorübergehend gelöscht, bitte vor der Stornierung wiederherstellen',
    'The order has been succesfully restored' => 'Die Bestellung wurde erfolgreich wiederhergestellt',
    'The order has been successfully validated' => 'Die Bestellung wurde erfolgreich validiert',
    'The order status must be paid or awaiting payment' => 'Der Bestellstatus muss bezahlt sein oder auf Zahlung warten.',
    'The organizer can not be found' => 'Der Veranstalter konnte nicht gefunden werden',
    'The organizer not be found' => 'Der Veranstalter konnte nicht gefunden werden',
    'The organizer revenue from this event date is currently zero' => 'Die Einnahmen des Veranstalters aus diesem Veranstaltungstermin sind derzeit Null',
    'The page can not be found' => 'Die Seite konnte nicht gefunden werden',
    'The page has been deleted' => 'Die Seite wurde entfernt',
    'The page has been successfully created' => 'Die Seite wurde erfolgreich erstellt',
    'The page has been successfully updated' => 'Die Seite wurde erfolgreich aktualisiert.',
    'The payment can not be found' => 'Die Bezahlung konnte nicht gefunden werden',
    'The payment gateway can not be found' => 'Zahlungsgateway nicht gefunden',
    'The payment gateway has been successfully created' => 'Das Zahlungsgateway wurde erfolgreich erstellt',
    'The payment gateway has been successfully updated' => 'Das Zahlungsgateway wurde erfolgreich aktualisiert',
    'The payout method can not be found' => 'Kann die Zahlungsmethode nicht finden',
    'The payout method has been successfully created' => 'Die Zahlungsmethode wurde erfolgreich erstellt',
    'The payout method has been successfully updated' => 'Die Zahlungsmethode wurde erfolgreich aktualisiert',
    'The payout method is unset' => 'Die Zahlungsmethode ist nicht konfiguriert',
    'The payout request can not be canceled because it is already processed' => 'Die Zahlungsanforderung kann nicht storniert werden, da sie bereits bearbeitet wurde',
    'The payout request can not be found' => 'Zahlungsanforderung kann nicht gefunden werden',
    'The payout request can not be processed at this moment' => 'Zahlungsanforderung kann derzeit nicht bearbeitet werden',
    'The payout request has been already processed' => 'Die Zahlungsaufforderung wurde bereits bearbeitet',
    'The payout request has been deleted' => 'Zahlungsaufforderung wurde gelöscht',
    'The payout request has been permanently canceled' => 'Die Zahlungsanforderung wurde endgültig storniert',
    'The payout request has been permanently deleted' => 'Zahlungsaufforderung wurde endgültig gelöscht',
    'The payout request has been soft deleted, restore it before canceling it' => 'Zahlungsanforderung wurde vorübergehend gelöscht, bitte vor dem Abbrechen wiederherstellen',
    'The payout request has been succesfully restored' => 'Die Zahlungsanforderung wurde erfolgreich wiederhergestellt.',
    'The payout request has been successfully processed' => 'Die Zahlungsanforderung wurde erfolgreich bearbeitet',
    'The payout request has been successfully submitted, you will be notified by email once it is processed' => 'Zahlungsanforderung wurde erfolgreich übermittelt, Sie werden per E-Mail benachrichtigt, sobald sie bearbeitet wurde',
    'The point of sale can not be found' => 'Kann die Verkaufsstelle nicht finden',
    'The point of sale has been deleted' => 'Die Verkaufsstelle wurde entfernt',
    'The point of sale has been disabled' => 'Die Verkaufsstelle wurde gelöscht',
    'The point of sale has been enabled' => 'Die Verkaufsstelle wurde ausgeschaltet',
    'The point of sale has been permenently deleted' => 'Die Verkaufsstelle wurde endgültig gelöscht',
    'The point of sale has been successfully created' => 'Die Verkaufsstelle wurde erfolgreich erstellt',
    'The point of sale has been successfully updated' => 'Die Verkaufsstelle wurde erfolgreich aktualisiert.',
    'The request method is known by the server but is not supported by the target resource' => 'Der Server kennt die Anfragemethode, aber die Zielressource unterstützt sie nicht',
    'The requested page couldn\'t be located. Checkout for any URL misspelling or' => 'Die angeforderte Seite konnte nicht gefunden werden. Auf Rechtschreibfehler in der URL prüfen oder',
    'The review can not be found' => 'Die Bewertung kann nicht gefunden werden',
    'The review has been deleted' => 'Die Bewertung wurden entfernt',
    'The review has been deleted permanently' => 'Die Bewertung wurde endgültig entfernt',
    'The review has been enabled' => 'Die Bewertung wurde aktiviert',
    'The review has been hidden' => 'Die Bewertung ist versteckt',
    'The review has been succesfully restored' => 'Die Bewertung wurde erfolgreich wiederhergestellt',
    'The scanner account is disabled by the organizer' => 'Das Scannerkonto wurde vom Veranstalter deaktiviert',
    'The scanner can not be found' => 'Der Scanner kann nicht gefunden werden',
    'The scanner has been disabled' => 'Der Scanner wurde deaktiviert',
    'The scanner has been enabled' => 'Der Scanner wurde aktiviert',
    'The scanner has been permenently deleted' => 'Der Scanner wurde endgültig gelöscht',
    'The scanner has been successfully created' => 'Der Scanner wurde erfolgreich erstellt',
    'The scanner has been successfully updated' => 'Der Scanner wurde erfolgreich aktualisiert.',
    'The settings have been updated' => 'Konfiguration wurde aktualisiert',
    'The space' => 'Der Platz',
    'The test email has been sent, please check the inbox of' => 'The test email has been sent, please check the inbox of',
    'The ticket can not be found' => 'Das Ticke kann nicht gefunden werden',
    'The ticket has already been scanned' => 'Das Ticket wurde bereits gescannt',
    'The ticket has been successfully scanned' => 'Das Ticket wurde erfolgreich gescannt.',
    'The ticket is not valid for this event date' => 'Das Ticket ist für diesen Veranstaltungstermin nicht gültig',
    'The ticket was already scanned at' => 'Das Ticket wurde bereits gescannt um',
    'The tickets has been successfully added to your cart' => 'Die Tickets wurden erfolgreich in Ihren Warenkorb gelegt.',
    'The user can not be found' => 'Der Benutzer konnte nicht gefunden werden',
    'The user cart has been emptied' => 'Der Benutzer Warenkorb wurde geleert',
    'The user has been deleted' => 'Benutzer wurde gelöscht',
    'The user has been disabled' => 'Benutzer wurde deaktiviert',
    'The user has been enabled' => 'Benutzer wurde aktiviert',
    'The user has been permanently deleted' => 'Benutzer wurde endgültig gelöscht',
    'The user has been succesfully restored' => 'Benutzer wurde erfolgreich wiederhergestellt',
    'The username already exists' => 'Der Benutzername existiert bereits',
    'The venue can not be deleted because it is linked with one or more events' => 'Der Ort kann nicht entfernt werden, da er mit einem oder mehreren Ereignissen verknüpft ist',
    'The venue can not be found' => 'Kann den Ort nicht finden',
    'The venue has been deleted' => 'Der Ort wurde entfernt',
    'The venue has been disabled' => 'Der Ort wurde deaktiviert',
    'The venue has been succesfully restored' => 'Der Ort wurde erfolgreich wiederhergestellt',
    'The venue has been successfully created' => 'Der Ort wurde erfolgreich erstellt',
    'The venue has been successfully updated' => 'Der Ort wurde erfolgreich aktualisiert.',
    'The venue is hidden' => 'Der Ort ist versteckt',
    'The venue is hidden from the public venues directory' => 'Der Ort ist im Verzeichnis der öffentlichen Orte versteckt',
    'The venue is listed on the public venues directory' => 'Der Ort ist im Verzeichnis der öffentlichen Orte aufgeführt',
    'The venue is visible' => 'Der Ort ist sichtbar',
    'The venue type can not be deleted because it is linked with one or more venues' => 'Der Ort kann nicht entfernt werden, da er mit einem oder mehreren Orten verknüpft ist',
    'The venue type can not be found' => 'Kann den Ortstyp nicht finden',
    'The venue type has been deleted' => 'Der Ortstyp wurde entfernt',
    'The venue type has been disabled' => 'Der Ortstyp wurde deaktiviert',
    'The venue type has been succesfully restored' => 'Der Ortstyp wurde erfolgreich wiederhergestellt',
    'The venue type has been successfully created' => 'Der Ortstyp wurde erfolgreich erstellt',
    'The venue type has been successfully updated' => 'Der Ortstyp wurde erfolgreich aktualisiert',
    'The venue type is hidden' => 'Der Ortstyp ist versteckt',
    'The venue type is visible' => 'Der Ortstyp ist sichtbar',
    'This email address will be used as the sender of all the emails sent by the platform, in almost all cases, it is the same as the username above' => 'Diese E-Mail-Adresse wird als Absender aller von der Plattform gesendeten E-Mails verwendet, in fast allen Fällen ist sie mit dem oben genannten Benutzernamen identisch',
    'This email address will be used to receive the quote requests, make sure to mention it if you want to show the quote form' => 'Diese E-Mail-Adresse wird verwendet, um Angebotsanfragen zu erhalten. Geben Sie sie unbedingt an, wenn Sie das Angebotsformular anzeigen möchten.',
    'This email address will receive the contact form messages' => 'Diese E-Mail-Adresse erhält die Nachrichten des Kontaktformulars',
    'This email is sent as a confirmation of your order' => 'Diese E-Mail wird als Bestätigung Ihrer Bestellung gesendet',
    'This email is sent to test the configuration of the mail server settings.' => 'This email is sent to test the configuration of the mail server settings.',
    'This event date is locked because a payout request has been submitted' => 'Das Datum dieses Ereignisses ist gesperrt, da eine Zahlungsaufforderung gesendet wurde',
    'This fee will be added to the ticket sale price which are bought from a point of sale, put 0 to disable additional fees for tickets which are bought from a point of sale, does not apply for free tickets, will be applied to future orders' => 'Diese Gebühr wird zum Verkaufspreis der Tickets hinzugefügt, die an einer Verkaufsstelle gekauft werden. Sie wird auf 0 gesetzt, um zusätzliche Gebühren für Tickets zu deaktivieren, die an einer Verkaufsstelle gekauft werden. Sie gilt nicht für kostenlose Tickets, sie wird auf zukünftige Bestellungen angewendet werden',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for tickets which are bought online, does not apply for free tickets, will be applied to future orders' => 'Diese Gebühr wird zum Verkaufspreis von online gekauften Tickets hinzugefügt. Geben Sie 0 ein, um zusätzliche Gebühren für online gekaufte Tickets zu deaktivieren. Sie gilt nicht für kostenlose Tickets, sie gilt für zukünftige Bestellungen',
    'This is a string that should be unique to your application and it is commonly used to add more entropy to security related operations' => 'Dies ist eine Zeichenfolge, die für Ihre Anwendung eindeutig sein sollte und häufig verwendet wird, um sicherheitsrelevanten Vorgängen mehr Sicherheit hinzuzufügen',
    'This link can only be used once to validate your account' => 'Dieser Link kann nur einmal verwendet werden, um Ihr Konto zu validieren',
    'This month' => 'Diesen Monat',
    'This payout method is currently disabled' => 'Diese Zahlungsmethode ist derzeit deaktiviert',
    'This percentage will be deducted from each ticket sold on a point of sale, upon organizer payout request, this percentage will be taken from each ticket sold on a point of sale, will be applied to future orders' => 'Dieser Prozentsatz wird von jedem an einer Verkaufsstelle verkauften Ticket abgezogen, auf Zahlungsaufforderung des Veranstalters wird dieser Prozentsatz von jedem an einer Verkaufsstelle verkauften Ticket abgezogen und für zukünftige Bestellungen verwendet',
    'This percentage will be deducted from each ticket sold online, upon organizer payout request, this percentage will be taken from each ticket sold online, will be applied to future orders' => 'Dieser Prozentsatz wird von jedem online verkauften Ticket abgezogen, auf Zahlungsaufforderung des Veranstalters wird dieser Prozentsatz von jedem online verkauften Ticket abgezogen und für zukünftige Bestellungen verwendet',
    'This ticket was scanned at %scanDate%' => 'Dieses Ticket wurde gescannt bei %scanDate%',
    'This week' => 'Diese Woche',
    'This weekend' => 'Dieses Wochenende',
    'Ticket' => 'Ticket',
    'Ticket description' => 'Ticketbeschreibung',
    'Ticket fee (Online)' => 'Systemgebühr (online)',
    'Ticket fee (Point Of Sale)' => 'Systemgebühr (Verkaufsstelle)',
    'Ticket fees' => 'Systemgebühr',
    'Ticket name' => 'Ticketname',
    'Ticket price' => 'Ticketpreis',
    'Ticket price percentage cut (Online)' => 'Prozentuale Ermäßigung des Ticketpreises (online)',
    'Ticket price percentage cut (Point of sale)' => 'Reduzierung des Prozentsatzes des Ticketpreises (Point of Sale)',
    'Ticket type' => 'Tickettyp',
    'Tickets' => 'Tickets',
    'Tickets left' => 'verkaufte Tickets ',
    'Tickets per attendee' => 'Tickets pro Teilnehmer',
    'Tickets sales' => 'Ticketverkäufe',
    'Tickets sales by date' => 'Ticketverkauf nach Datum',
    'Tickets sales this month' => 'Ticketverkauf diesen Monat',
    'Tickets sold' => 'Tickets verkauft',
    'Tickets sold Per Point of sale' => 'Ticketverkauf nach Verkaufsstelle',
    'Tickets sold by channel' => 'Nach Kanal verkaufte Tickets',
    'Tickets types' => 'Tickettypen',
    'Timeleft' => 'Verbleibende Zeit',
    'Timezone' => 'Zeitzone',
    'Titel' => 'Titel',
    'Title' => 'Titel',
    'Titre' => 'Titel',
    'To help attendee find your event quickly, enter some keywords that identify your event (press Enter after each entry)' => 'Damit die Teilnehmer Ihre Veranstaltung schnell finden, geben Sie einige Schlüsselwörter ein, die Ihre Veranstaltung identifizieren (drücken Sie nach jedem Eintrag die Eingabetaste).',
    'To reset your password, click on the following button and follow the instructions' => 'Um Ihr Passwort zurückzusetzen, klicken Sie auf die Schaltfläche unten und folgen Sie den Anweisungen',
    'To submit a new payout request for an event date, go to the My events page and click on the Request payout link next to the event' => 'Um eine neue Zahlungsanforderung für ein Veranstaltungsdatum zu senden, gehen Sie zur Seite Meine Veranstaltungen und klicken Sie neben der Veranstaltung auf den Link Zahlung anfordern.',
    'Today' => 'Heute',
    'Toggle display the event date details' => 'Details zum Ereignisdatum anzeigen / umschalten',
    'Toggle display the search filters' => 'Suchfilter anzeigen / umschalten',
    'Tomorrow' => 'Morgen',
    'Total' => 'Total',
    'Total attendees' => 'Gesamtzahl der Teilnehmer',
    'Total attendees check-in' => 'Gesamtzahl der registrierten Teilnehmer',
    'Total gross sales' => 'Gesamtbruttoumsatz',
    'Total orders' => 'Gesamtbestellungen',
    'Total sales' => 'Gesamtumsatz',
    'Total tickets sales' => 'Gesamter Ticketverkauf',
    'Translation' => 'Übersetzung',
    'Translations' => 'Übersetzungen',
    'Transport' => 'Transport',
    'Twitter' => 'Twitter',
    'Twitter url' => 'Twitter url',
    'Type' => 'Typ',
    'Título' => 'Titel',
    'Unfollow' => 'entfolgen',
    'Unknown' => 'Unbekannt',
    'Until date' => 'Bis zum Datum',
    'Upcoming events' => 'Kommende Veranstaltungen',
    'Update cart' => 'Warenkorb aktualisieren',
    'Update date' => 'Aktualisierungsdatum',
    'Update the amenity' => 'Annehmlichkeiten aufrüsten',
    'Update the audience' => 'Aktualisieren Sie das Publikum',
    'Update the blog post' => 'Blogbeitrag aktualisieren',
    'Update the blog post category' => 'Blogpostkategorie aktualisieren',
    'Update the category' => 'Kategorie aktualisieren',
    'Update the country' => 'Aktualisieren Sie das Land',
    'Update the currency' => 'Aktualisieren Sie die Währung',
    'Update the event' => 'Aktualisieren Sie die Veranstaltung',
    'Update the help center article' => 'Hilfeartikel aktualisieren',
    'Update the help center category' => 'Hilfe Center Kategorie aktualisieren',
    'Update the language' => 'Sprache aktualisieren',
    'Update the lapagenguage' => 'Sprache aktualisieren',
    'Update the payment gateway' => 'Aktualisieren Sie das Zahlungsgateway',
    'Update the point of sale' => 'Aktualisieren Sie die Verkaufsstelle',
    'Update the scanner' => 'Aktualisieren Sie den Scanner',
    'Update the venue' => 'Aktualisieren Sie den Ort',
    'Update the venue type' => 'Aktualisieren Sie den Ortstyp',
    'Update your %payoutMethodName% payout method' => 'Aktualisieren Sie Ihre Zahlungsmethode %payoutMethodName%',
    'Used in some specific cases, follow this link for a list of supported characters: https://www.php.net/manual/en/datetime.format.php . Please make sure to keep the double quotes " " around the format string' => 'In bestimmten Fällen verwendet, folgen Sie diesem Link für eine Liste der unterstützten Zeichen: https://www.php.net/manual/en/datetime.format.php. Achten Sie darauf, die doppelten Anführungszeichen "" um die Formatzeichenfolge beizubehalten.',
    'User information' => 'Nutzerinformation',
    'Username' => 'Benutzername',
    'Users' => 'Benutzer',
    'Users summary' => 'Benutzerzusammenfassung',
    'Uset' => 'Verwendet',
    'Validate' => 'Bestätigen',
    'Venue' => 'Veranstaltungsort',
    'Venue / Location' => 'Veranstaltungsort / Location',
    'Venue image' => 'Bild des Veranstaltungsortes',
    'Venue name...' => 'Name des Veranstaltungsortes...',
    'Venue page' => 'Website des Veranstaltungsortes',
    'Venue page settings' => 'Seiteneinstellungen Veranstaltungsort',
    'Venue type' => 'Orttyp',
    'Venue types' => 'Ortstypen',
    'Venues' => 'Veranstaltungsorte',
    'Venues Pages' => 'Seiten des Veranstaltungsortes',
    'Venues count' => 'Kapazität des Veranstaltungsortes',
    'Venues page' => 'Website des Veranstaltungsortes',
    'Video' => 'Vídeo',
    'View cart' => 'Warenkorb anzeigen',
    'View detailed statistics' => 'Detaillierte Statistiken anzeigen',
    'View details' => 'Zeige Details',
    'View event' => 'Zeige Veranstaltungen',
    'View organizer' => 'Zeige Veranstalter',
    'View stats' => 'Zeige Statistiken',
    'Views' => 'Aufrufe',
    'Visible' => 'Sichtbar',
    'Visible only' => 'Nur sichtbare',
    'We recommend a 48x48 image size' => 'Wir empfehlen eine Bildgröße von 48 x 48',
    'We will be back shortly.' => 'Wir sind in Kürze wieder da.',
    'Website' => 'Webseite',
    'Website name' => 'Webseitname',
    'Website root url' => 'Website-Root-URL',
    'Website slug' => 'Website slug',
    'Website url' => 'Webseitenadresse',
    'Welcome' => 'Wilkommen',
    'What to show in the homepage hero ?' => 'Was soll auf der Startseite Hero angezeigt werden?',
    'When' => 'Wann',
    'Where' => 'Woher',
    'Will be show in the homepage, the explore menu item dropdown and in the footer' => 'Es wird auf der Startseite, im Dropdown-Menü des Navigationselements und in der Fußzeile angezeigt.',
    'Year' => 'Jahr',
    'Yellow' => 'Belb',
    'Yes' => 'Ja',
    'You are about to approve the payout request' => 'Sie sind im Begriff, die Zahlungsanforderung zu genehmigen',
    'You are about to cancel this order (this action cannot be undone)' => 'Sie sind im Begriff, diese Bestellung zu stornieren (diese Aktion kann nicht rückgängig gemacht werden)',
    'You are about to cancel this payout request (this action cannot be undone), the event date related to this payout request will be unlocked' => 'Sie sind im Begriff, diese Zahlungsanforderung zu stornieren (diese Aktion kann nicht rückgängig gemacht werden), das Ereignisdatum für diese Zahlungsanforderung wird entsperrt',
    'You are about to delete the amenity PERMANENTLY' => 'Sie sind dabei, die Annehmlichkeiten DAUERHAFT zu entfernen',
    'You are about to delete the article PERMANENTLY' => 'Sie sind im Begriff, den Artikel DAUERHAFT zu löschen',
    'You are about to delete the audience PERMANENTLY' => 'Du bist dabei, die Zielgruppe PERMANENT zu löschen',
    'You are about to delete the blog post PERMANENTLY' => 'Du bist dabei, den Blog-Beitrag DAUERHAFT zu löschen',
    'You are about to delete the blog post category PERMANENTLY' => 'Du bist dabei, die Kategorie PERMANENT aus dem Blogpost zu entfernen',
    'You are about to delete the category PERMANENTLY' => 'Du bist dabei, die Kategorie PERMANENT aus dem Blogpost zu entfernen',
    'You are about to delete the country PERMANENTLY' => 'Sie sind dabei, das Land DAUERHAFT zu löschen',
    'You are about to delete the currency PERMANENTLY' => 'Sie sind dabei, die Münze DAUERHAFT zu löschen',
    'You are about to delete the event and all its related information PERMANENTLY' => 'Sie sind dabei, die Veranstaltung und alle zugehörigen Informationen DAUERHAFT zu löschen',
    'You are about to delete the language PERMANENTLY' => 'Sie sind dabei, die Sprache DAUERHAFT zu löschen',
    'You are about to delete the order and all its related information (payment details, tickets...)' => 'Sie sind im Begriff, die Bestellung und alle zugehörigen Informationen (Zahlungsdetails, Tickets ...) zu löschen.',
    'You are about to delete the page PERMANENTLY' => 'Sie sind dabei, die Seite DAUERHAFT zu löschen',
    'You are about to delete the payout request and all its related information' => 'Sie sind im Begriff, die Zahlungsanforderung und alle zugehörigen Informationen zu löschen.',
    'You are about to delete the point of sale' => 'Sie sind dabei, die Verkaufsstelle zu löschen',
    'You are about to delete the point of sale PERMANENTLY' => 'Sie sind dabei, die Verkaufsstelle DAUERHAFT zu löschen',
    'You are about to delete the review PERMANENTLY' => 'Sie sind dabei, die Bewertung DAUERHAFT zu löschen',
    'You are about to delete the scanner' => 'Sie sind dabei, den Scanner zu löschen',
    'You are about to delete the scanner PERMANENTLY' => 'Sie sind dabei, den Scanner DAUERHAFT zu löschen',
    'You are about to delete the user and all its related information (orders, events...) PERMANENTLY' => 'Sie sind im Begriff, den Benutzer und alle zugehörigen Informationen (Bestellungen, Ereignisse ...) DAUERHAFT zu löschen',
    'You are about to delete the venue PERMANENTLY' => 'Sie sind dabei, den Ort DAUERHAFT zu löschen',
    'You are about to delete the venue type PERMANENTLY' => 'Sie sind dabei, den Ortstyp DAUERHAFT zu löschen',
    'You are about to empty your cart' => 'Sie sind dabei, Ihren Warenkorb zu leeren',
    'You are about to validate this order, generate the tickets and send a confirmation email to the attendee' => 'Sie sind dabei, diese Bestellung zu validieren, die Tickets zu generieren und eine Bestätigungs-E-Mail an den Teilnehmer zu senden',
    'You are connected as "%username%' => 'Sie sind eingeloggt als "% username%',
    'You are following this organizer' => 'Du folgst diesem Veranstalter',
    'You are going to this event' => 'Du gehst zu dieser Veranstaltung',
    'You are logged in as:' => 'Du bist eingeloggt als:',
    'You are no longer following this organizer' => 'Du folgst diesem Veranstalter nicht mehr',
    'You are not following any organizer' => 'Du folgst keinem Veranstalter',
    'You can introduce the event details in multiple locales' => 'Sie können die Veranstaltungsdetails an verschiedenen Stellen eingeben',
    'You did not find an answer to your inquiry? Let us know and we will be glad to give you further help' => 'Haben Sie keine Antwort auf Ihre Anfrage gefunden? Lassen Sie es uns wissen und wir helfen Ihnen gerne weiter.',
    'You don\'t have permission to access this resource' => 'Sie sind nicht berechtigt, auf diese Ressource zuzugreifen',
    'You have added %tickets% ticket(s) to your cart' => 'Sie haben %tickets% ticket(s) in ihrem Warenkorb',
    'You have already bought %tickets% ticket(s)' => 'Sie haben bereits %tickets% eckets gekauft',
    'You have received a new quote request for the venue' => 'Sie haben eine neue Angebotsanfrage für den Veranstaltungsort erhalten',
    'You have successfully subscribed to our newsletter' => 'Sie haben unseren Newsletter erfolgreich abonniert',
    'You must choose an event and set the status to paid in order to export attendees list to a PDF file' => 'Sie müssen eine Veranstaltung auswählen und den Status auf bezahlt setzen, um die Teilnehmerliste in eine PDF-Datei zu exportieren',
    'You must choose an event in order to export the attendees list' => 'Sie müssen ein Ereignis auswählen, um die Teilnehmerliste zu exportieren.',
    'You must review your cart before proceeding to checkout' => 'Sie müssen Ihren Warenkorb überprüfen, bevor Sie mit der Zahlung fortfahren.',
    'You must set the status to paid in order to export the attendees list' => 'Sie müssen den Status auf bezahlt setzen, um die Teilnehmerliste zu exportieren',
    'You must specify at least one language' => 'Sie müssen mindestens eine Sprache angeben',
    'You order is empty' => 'Dein Warenkorb ist leer',
    'Your account settings have been updated' => 'Ihre Kontoeinstellungen wurden aktualisiert',
    'Your cart has been automatically updated because one or more event\'s quotas has changed' => 'Ihr Warenkorb wurde automatisch aktualisiert, weil das Kontingent für eine oder mehrere Veranstaltungen geändert wurde',
    'Your cart has been automatically updated because one or more events are no longer on sale' => 'Ihr Warenkorb wurde automatisch aktualisiert, da eine oder mehrere Veranstaltungen nicht mehr im Angebot sind',
    'Your cart has been emptied' => 'Ihr Warenkorb wurde geleert',
    'Your cart has been updated' => 'Ihr Warenkorb wurde aktualisiert',
    'Your cart is empty' => 'Ihr Warenkorb ist leer',
    'Your email' => 'deine E-Mail',
    'Your message has been successfully sent' => 'Ihre Nachricht wurde erfolgreich gesendet',
    'Your order has been automatically canceled because one or more event\'s quotas has changed' => 'Ihre Bestellung wurde automatisch storniert, da sich die Gebühren für eine oder mehrere Veranstaltungen geändert haben.',
    'Your order has been automatically canceled because one or more events are no longer on sale' => 'Ihre Bestellung wurde automatisch storniert, da eine oder mehrere Veranstaltungen nicht mehr zum Verkauf stehen',
    'Your order has been automatically canceled because your ticket reservations has been released' => 'Ihre Bestellung wurde automatisch storniert, da Ihre Ticketreservierungen freigegeben wurden.',
    'Your order has been successfully placed, please proceed to the payment as explained in the instructions' => 'Ihre Bestellung wurde erfolgreich aufgegeben, bitte fahren Sie mit der Zahlung fort, wie in den Anweisungen beschrieben',
    'Your organizer profile has been successfully updated' => 'Ihr Veranstalterprofil wurde erfolgreich aktualisiert',
    'Your payment could not be processed at this time' => 'Ihre Zahlung konnte derzeit nicht verarbeitet werden',
    'Your payment has been successfully processed' => 'Ihre Zahlung wurde erfolgreich verarbeitet',
    'Your payment operation was canceled' => 'Ihre Zahlungstransaktion wurde abgebrochen',
    'Your payout request has been processed' => 'Ihre Zahlungsanfrage wurde bearbeitet',
    'Your quote request has been successfully sent' => 'Ihre Angebotsanfrage wurde erfolgreich versendet',
    'Your rating (out of 5 stars)' => 'Ihre Bewertung (von 5 Sternen)',
    'Your registration has been successfully processed' => 'Ihre Anmeldung wurde erfolgreich bearbeitet',
    'Your review has been successfully saved' => 'Ihre Bewertung wurde erfolgreich gespeichert',
    'Your review headline' => 'Titel deiner Bewertung',
    'Your tickets are not reserved until checkout, the quantity you intend to buy might not be available if you do not proceed to checkout right away' => 'Ihre Tickets sind erst zum Zeitpunkt der Zahlung reserviert. Die Menge, die Sie kaufen möchten, ist möglicherweise nicht verfügbar, wenn Sie nicht sofort mit der Zahlung fortfahren',
    'Your tickets bought from' => 'Ihre Tickets gekauft bei',
    'Youtube' => 'Youtube',
    'Youtube url' => 'Youtube Url',
    'Youtube video' => 'Youtube Video',
    'Youtube video url' => 'Youtube-Video-URL',
    'Zip / Postal code' => 'postleitzahl',
    'and' => 'und',
    'asc' => 'asc',
    'checked In' => 'registriert',
    'created at' => 'Erstellt am',
    'desc' => 'Beschreibung',
    'event to the next level ?' => 'auf die nächste Stufe zu bringen?',
    'for' => 'für',
    'form.label.delete' => 'form.label.Löschen',
    'form.password' => 'Passwort',
    'form.password_confirmation' => 'Passwort Bestätigung',
    'image(s)' => 'Bild(er)',
    'left' => 'links',
    'left before tickets are released' => 'verlassen, bevor die Tickets freigegeben werden',
    'min read' => 'Mindestablesung',
    'my points of sale' => 'meine Verkaufsstellen',
    'my scanners' => 'meine Scanner',
    'my venues' => 'meine Orte',
    'orders summary' => 'Bestellübersicht',
    'out of 5 stars' => 'von 5 Sternen',
    'placed on' => 'platziert in',
    'return to the homepage' => 'Zurück zur Startseite',
    'review' => 'Bewertung',
    'right' => 'rechts',
    'ticket' => 'Ticket',
    'ticket(s)' => 'Ticket',
    'ticket(s) sold' => 'Ticket(s) verkauft',
    'tickets' => 'Tickets',
    'tickets found in your cart' => 'Tickets in Ihrem Warenkorb gefunden',
    'tickets left' => 'verbleibende Tickets',
    'tickets per attendee' => 'Einträge pro Teilnehmer',
    'to edit your profile' => 'um dein Profil zu bearbeiten',
    'to manage this event' => 'um diese Veranstaltung zu verwalten',
    'to manage your event' => 'um Ihre Veranstaltung zu verwalten',
    'to preview your profile' => 'um eine Vorschau Ihres Profils anzuzeigen',
    'to return to your dashboard' => 'zurück zu dem Dashboard',
    'user(s)' => 'Benutzer',
    'view(s)' => 'Ansichten',
    'views' => 'Ansichten',
    'your payout request has been processed' => 'Ihre Auszahlungsanfrage wurde bearbeitet',
    'your tickets are ready to go!' => 'Ihre Tickets sind fertig!',
    'اسم' => 'اسم',
    'اسم القائمة' => 'اسم القائمة',
    'التفاصيل' => 'التفاصيل',
    'العلامات' => 'العلامات',
    'الكلمات الرئيسية' => 'الكلمات الرئيسية',
    'تعليمات' => 'تعليمات',
    'عنوان' => 'عنوان',
    'فقرة' => 'فقرة',
    'محتوى' => 'محتوى',
    'نص الرابط' => 'نص الرابط',
    'نص العنوان' => 'نص العنوان',
  ),
  'javascript' => 
  array (
    'Add' => 'hinzufügen',
    'Add a new event date' => 'Neues Veranstaltungsdatum hinzufügen',
    'Add a new ticket' => 'Neues Ticket hinzufügen',
    'An error has occured' => 'Ein Fehler ist aufgetreten',
    'April' => 'April',
    'August' => 'August',
    'Cancel' => 'abbrechen',
    'Close' => 'schließen',
    'Confirm' => 'bestätigen',
    'Confirmation required' => 'Bestätigung erforderlich',
    'Day' => 'Tag',
    'December' => 'Dezember',
    'Duplicate this event date' => 'Dieses Veranstaltungsdatum duplizieren',
    'Duplicate this ticket' => 'Dieses Ticket duplizieren',
    'Email address' => 'Email Adresse',
    'February' => 'Februar',
    'Insert at least 3 characters' => 'Fügen Sie mindestens 3 Zeichen ein',
    'January' => 'Januar',
    'July' => 'Juli',
    'June' => 'Juni',
    'Load more' => 'mehr laden',
    'Loading...' => 'Lade...',
    'Mail server test email' => 'Mail server test email',
    'Make sure to enter a valid email address' => 'Stellen Sie sicher, dass Sie eine gültige E-Mail-Adresse eingeben',
    'March' => 'März',
    'May' => 'Mai',
    'Message' => 'Nachricht',
    'Month' => 'Monat',
    'Move down' => 'abwärts bewegen',
    'Move up' => 'aufwärts bewegen',
    'No results found' => 'keine Ergebnisse gefunden',
    'Note' => 'Hinweis',
    'November' => 'November',
    'October' => 'Oktober',
    'Please select the tickets quantity for this order' => 'Bitte wählen Sie die Anzahl der Tickets für diese Bestellung',
    'Please select the tickets quantity you want to buy' => 'Bitte wählen Sie die Anzahl der Tickets aus, die Sie kaufen möchten',
    'Read more' => 'mehr lesen',
    'Remove' => 'Entfernen',
    'Remove this event date' => 'Dieses Veranstaltungsdatum entfernen',
    'Remove this ticket' => 'Dieses Ticket entfernen',
    'Return to cart' => 'zurück zum Warenkorb',
    'Searching ...' => 'Suchen ...',
    'Select an option' => 'wähle eine Option',
    'Send' => 'Send',
    'September' => 'September',
    'Stick' => 'Stick',
    'The email address is not valid' => 'Diese Email ist nicht gültig',
    'The tickets have been released' => 'Die Tickets sind freigegeben',
    'This feature is disabled in demo mode' => 'Diese Funktion ist im Demo-Modus deaktiviert
',
    'Time\'s up' => 'Die Zeit ist um',
    'Today' => 'Heute',
    'Unstick' => 'Abheben',
    'Week' => 'Woche',
    'days' => 'Tage',
    'days.Fri' => 'Fre',
    'days.Mon' => 'Mon',
    'days.Sat' => 'Sam',
    'days.Sun' => 'Son',
    'days.Thu' => 'Don',
    'days.Tue' => 'Die',
    'days.Wed' => 'Mit',
    'hr' => 'Stunde',
    'min' => 'Minute',
    'sec' => 'Sekunde',
    'weeks' => 'Wochen',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'fos_user.username.already_used' => 'The username is already used.',
    'fos_user.username.blank' => 'Please enter a username.',
    'fos_user.username.short' => 'The username is too short.',
    'fos_user.username.long' => 'The username is too long.',
    'fos_user.email.already_used' => 'The email is already used.',
    'fos_user.email.blank' => 'Please enter an email.',
    'fos_user.email.short' => 'The email is too short.',
    'fos_user.email.long' => 'The email is too long.',
    'fos_user.email.invalid' => 'The email is not valid.',
    'fos_user.password.blank' => 'Please enter a password.',
    'fos_user.password.short' => 'The password is too short.',
    'fos_user.password.mismatch' => 'The entered passwords don\'t match.',
    'fos_user.new_password.blank' => 'Please enter a new password.',
    'fos_user.new_password.short' => 'The new password is too short.',
    'fos_user.current_password.invalid' => 'The entered password is invalid.',
    'fos_user.group.blank' => 'Please enter a name.',
    'fos_user.group.short' => 'The name is too short.',
    'fos_user.group.long' => 'The name is too long.',
    'fos_group.name.already_used' => 'The name is already used.',
    'This value is not a valid captcha.' => 'This value is not a valid captcha.',
    'The captcha was not resolved on the right domain.' => 'The captcha was not resolved on the right domain.',
    'validator.credit_card.invalidDate' => 'This value should be a valid date.',
    'Please enter a message' => 'Please enter a message',
    'Please enter a permalink' => 'Please enter a permalink',
    'Please enter an id' => 'Please enter an id',
    'Please provide a valid url' => 'Please provide a valid url',
    'The file should be an image' => 'The file should be an image',
    'The message is too short|The message is too short' => 'The message is too short|The message is too short',
    'The password fields must match.' => 'The password fields must match.',
    'You must set the default locale at least for the translation fields' => 'You must set the default locale at least for the translation fields',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Previous',
    'label_next' => 'Next',
  ),
  'VichUploaderBundle' => 
  array (
    'download' => 'Download',
    'form.label.delete' => 'Delete?',
  ),
  'FOSUserBundle' => 
  array (
    'group.edit.submit' => 'Update group',
    'group.show.name' => 'Group name',
    'group.new.submit' => 'Create group',
    'group.flash.updated' => 'The group has been updated.',
    'group.flash.created' => 'The group has been created.',
    'group.flash.deleted' => 'The group has been deleted.',
    'security.login.username' => 'Username',
    'security.login.password' => 'Password',
    'security.login.remember_me' => 'Remember me',
    'security.login.submit' => 'Log in',
    'profile.show.username' => 'Username',
    'profile.show.email' => 'Email',
    'profile.edit.submit' => 'Update',
    'profile.flash.updated' => 'The profile has been updated.',
    'change_password.submit' => 'Change password',
    'change_password.flash.success' => 'The password has been changed.',
    'registration.check_email' => 'An email has been sent to %email%. It contains an activation link you must click to activate your account.
',
    'registration.confirmed' => 'Congrats %username%, your account is now activated.',
    'registration.back' => 'Back to the originating page.',
    'registration.submit' => 'Register',
    'registration.flash.user_created' => 'The user has been created successfully.',
    'registration.email.subject' => 'Welcome %username%!',
    'registration.email.message' => 'Hello %username%!

To finish activating your account - please click on the following link %confirmationUrl%

This link can only be used once to validate your account.

Regards,
the Team.
',
    'resetting.check_email' => 'An email has been sent. It contains a link you must click to reset your password.
Note: You can only request a new password once within %tokenLifetime% hours.

If you don\'t get an email check your spam folder or try again.
',
    'resetting.request.username' => 'Username or email address',
    'resetting.request.submit' => 'Reset password',
    'resetting.reset.submit' => 'Change password',
    'resetting.flash.success' => 'The password has been reset successfully.',
    'resetting.email.subject' => 'Reset Password',
    'resetting.email.message' => 'Hello %username%!

To reset your password - please visit %confirmationUrl%

Regards,
the Team.
',
    'layout.logout' => 'Log out',
    'layout.login' => 'Log in',
    'layout.register' => 'Register',
    'layout.logged_in_as' => 'Logged in as %username%',
    'form.group_name' => 'Group name',
    'form.username' => 'Username',
    'form.email' => 'Email',
    'form.current_password' => 'Current password',
    'form.password' => 'Password',
    'form.password_confirmation' => 'Repeat password',
    'form.new_password' => 'New password',
    'form.new_password_confirmation' => 'Repeat new password',
    'Password' => 'Password',
    'Privacy policy' => 'Privacy policy',
    'Terms of service' => 'Terms of service',
    'Welcome' => 'Welcome',
  ),
  'HWIOAuthBundle' => 
  array (
    'header.connecting' => 'Connecting',
    'header.success' => 'Successfully connected the account "%name%"!',
    'header.register' => 'Register with the account "%name%"',
    'header.registration_success' => 'Successfully registered and connected the account "%username%"!',
    'connect.confirm.cancel' => 'Cancel',
    'connect.confirm.submit' => 'Connect account',
    'connect.confirm.text' => 'Are you sure that you want to connect your %service% account "%name%" to your current account?',
    'connect.registration.cancel' => 'Cancel',
    'connect.registration.submit' => 'Register account',
  ),
  'time' => 
  array (
    'diff.ago.year' => '1 year ago|%count% years ago',
    'diff.ago.month' => '1 month ago|%count% months ago',
    'diff.ago.day' => '1 day ago|%count% days ago',
    'diff.ago.hour' => '1 hour ago|%count% hours ago',
    'diff.ago.minute' => '1 minute ago|%count% minutes ago',
    'diff.ago.second' => '1 second ago|%count% seconds ago',
    'diff.empty' => 'now',
    'diff.in.second' => 'in 1 second|in %count% seconds',
    'diff.in.hour' => 'in 1 hour|in %count% hours',
    'diff.in.minute' => 'in 1 minute|in %count% minutes',
    'diff.in.day' => 'in 1 day|in %count% days',
    'diff.in.month' => 'in 1 month|in %count% months',
    'diff.in.year' => 'in 1 year|in %count% years',
  ),
  'FOSCommentBundle' => 
  array (
    'fos_comment_comment_new_headline_first' => 'You are the first to comment !',
    'fos_comment_comment_new_headline' => 'Add a new comment',
    'fos_comment_comment_new_submit' => 'Save',
    'fos_comment_comment_new_cancel' => 'Cancel',
    'fos_comment_comment_edit_submit' => 'Save',
    'fos_comment_comment_edit_cancel' => 'Cancel',
    'fos_comment_comment_reply_reply_to' => 'Reply',
    'fos_comment_comment_reply_cancel' => 'Cancel',
    'fos_comment_comment_show_by' => 'By',
    'fos_comment_comment_show_voteup' => 'Vote up',
    'fos_comment_comment_show_votedown' => 'Vote down',
    'fos_comment_comment_show_reply' => 'Reply',
    'fos_comment_comment_vote_score' => 'Vote',
    'fos_comment_comment_tree_load_more' => 'Load More Replies',
    'fos_comment_rss_feed' => 'RSS Feed',
    'fos_comment_thread_close' => 'Close thread',
    'fos_comment_thread_open' => 'Open thread',
    'fos_comment_thread_comment_count' => 'Comments',
    'fos_comment_comment_edit' => 'Edit',
    'fos_comment_comment_delete' => 'Delete',
    'fos_comment_comment_undelete' => 'Comment undeleted',
    'fos_comment_comment_deleted' => 'Comment deleted',
  ),
  'PayumBundle' => 
  array (
    'form.credit_card.holder' => 'Holder Name',
    'form.credit_card.expire_at' => 'Expiration Date',
    'form.credit_card.number' => 'Card Number',
    'form.credit_card.security_code' => 'Security (CVV) Code',
    'form.choice.paypal_express_checkout' => 'Paypal Express Checkout',
  ),
  'messages' => 
  array (
    'coresphere_console.headline.index' => 'Console',
    'coresphere_console.working_directory' => 'Working directory',
    'coresphere_console.environment' => 'Environment',
    'coresphere_console.welcome_message' => 'Type %command% to get a list of all commands.',
    'coresphere_console.loading' => 'Loading...',
    'coresphere_console.suggestion_head' => 'Did you mean:',
    'coresphere_console.empty_response' => 'Complete!',
    '%cartElementsCount% event(s) currently in cart' => '%cartElementsCount% event(s) currently in cart',
    '%mins% left before tickets are released' => '%mins% left before tickets are released',
    '%resultsCount% attendee(s) found' => '%resultsCount% attendee(s) found',
    '%resultsCount% event date(s) found' => '%resultsCount% event date(s) found',
    '%resultsCount% event(s)' => '%resultsCount% event(s)',
    '%resultsCount% event(s) currently on sale' => '%resultsCount% event(s) currently on sale',
    '%resultsCount% event(s) found' => '%resultsCount% event(s) found',
    '%resultsCount% post(s) found' => '%resultsCount% post(s) found',
    '%resultsCount% result(s) found' => '%resultsCount% result(s) found',
    '%resultsCount% results found' => '%resultsCount% results found',
    '%resultsCount% reviews(s) found' => '%resultsCount% reviews(s) found',
    '%tickets% ticket(s) are still reserved for you, please wait until the reservation expires at %expirationDate% in order to purchase more tickets' => '%tickets% ticket(s) are still reserved for you, please wait until the reservation expires at %expirationDate% in order to purchase more tickets',
    '%websiteName% is undergoing a scheduled maintenance.' => '%websiteName% is undergoing a scheduled maintenance.',
    1 => '1',
    '1 star' => '1 star',
    10 => '10',
    11 => '11',
    12 => '12',
    13 => '13',
    14 => '14',
    15 => '15',
    2 => '2',
    '2 stars' => '2 stars',
    3 => '3',
    '3 stars' => '3 stars',
    4 => '4',
    '4 stars' => '4 stars',
    5 => '5',
    '5 stars' => '5 stars',
    6 => '6',
    7 => '7',
    8 => '8',
    9 => '9',
    'A payout can not be requested on a free event date' => 'A payout can not be requested on a free event date',
    'A payout can only be requested after at least one online successful sale' => 'A payout can only be requested after at least one online successful sale',
    'A payout is already requested for this event date' => 'A payout is already requested for this event date',
    'About the organizer' => 'About the organizer',
    'About us' => 'About us',
    'Absatz' => 'Absatz',
    'Access denied' => 'Access denied',
    'Access granted' => 'Access granted',
    'Access is denied. You may not have the appropriate permissions to access this resource.' => 'Access is denied. You may not have the appropriate permissions to access this resource.',
    'Account' => 'Account',
    'Account information' => 'Account information',
    'Account settings' => 'Account settings',
    'Account status' => 'Account status',
    'Actions' => 'Actions',
    'Active attendees' => 'Active attendees',
    'Active organizers' => 'Active organizers',
    'Add a blog post' => 'Add a blog post',
    'Add a help center article' => 'Add a help center article',
    'Add a new amenity' => 'Add a new amenity',
    'Add a new audience' => 'Add a new audience',
    'Add a new blog post' => 'Add a new blog post',
    'Add a new blog post category' => 'Add a new blog post category',
    'Add a new category' => 'Add a new category',
    'Add a new country' => 'Add a new country',
    'Add a new currency' => 'Add a new currency',
    'Add a new event' => 'Add a new event',
    'Add a new help center article' => 'Add a new help center article',
    'Add a new help center category' => 'Add a new help center category',
    'Add a new language' => 'Add a new language',
    'Add a new page' => 'Add a new page',
    'Add a new payment gateway' => 'Add a new payment gateway',
    'Add a new point of sale' => 'Add a new point of sale',
    'Add a new scanner' => 'Add a new scanner',
    'Add a new venue' => 'Add a new venue',
    'Add a new venue type' => 'Add a new venue type',
    'Add events to your favorites by clicking the heart button' => 'Add events to your favorites by clicking the heart button',
    'Add other images that represent your event to be displayed as a gallery' => 'Add other images that represent your event to be displayed as a gallery',
    'Add to calendar' => 'Add to calendar',
    'Add to cart' => 'Add to cart',
    'Add to favorites' => 'Add to favorites',
    'Add your review' => 'Add your review',
    'Add your review for %eventname%' => 'Add your review for %eventname%',
    'Added to favorites by' => 'Added to favorites by',
    'Additional note' => 'Additional note',
    'Address' => 'Address',
    'After editing a translation in the javascript domain, go to the Console page and execute the following command to update the related files: bazinga:js-translation:dump assets/js --format=js --merge-domains' => 'After editing a translation in the javascript domain, go to the Console page and execute the following command to update the related files: bazinga:js-translation:dump assets/js --format=js --merge-domains',
    'After editing a translation in the javascript domain, make sure to execute the following command to update the related files: php bin/console bazinga:js-translation:dump assets/js --format=js --merge-domains' => 'After editing a translation in the javascript domain, make sure to execute the following command to update the related files: php bin/console bazinga:js-translation:dump assets/js --format=js --merge-domains',
    'After editing a translation message, go to the Console page and execute the following command: cache:clear --env=prod in order to apply the changes in the production environment' => 'After editing a translation message, go to the Console page and execute the following command: cache:clear --env=prod in order to apply the changes in the production environment',
    'All' => 'All',
    'All categories' => 'All categories',
    'All event dates for an organizer' => 'All event dates for an organizer',
    'All orders for an organizer' => 'All orders for an organizer',
    'All payout requests for an organizer' => 'All payout requests for an organizer',
    'Allow Paypal as a payout method for the organizers to receive their revenue' => 'Allow Paypal as a payout method for the organizers to receive their revenue',
    'Allow Stripe as a payout method for the organizers to receive their revenue' => 'Allow Stripe as a payout method for the organizers to receive their revenue',
    'Allow attendees to leave reviews' => 'Allow attendees to leave reviews',
    'Allow tap to check in on the scanner app' => 'Allow tap to check in on the scanner app',
    'Already have an account?' => 'Already have an account?',
    'Alternative date and time format' => 'Alternative date and time format',
    'Amenities' => 'Amenities',
    'Amount' => 'Amount',
    'An error has occured' => 'An error has occured',
    'An error has occured while processing your request' => 'An error has occured while processing your request',
    'An error might occur if the command execution time reaches your PHP max_execution_time directive' => 'An error might occur if the command execution time reaches your PHP max_execution_time directive',
    'Anweisungen' => 'Anweisungen',
    'Anything' => 'Anything',
    'Anytime' => 'Anytime',
    'Anywhere' => 'Anywhere',
    'App Debugging' => 'App Debugging',
    'App Environment' => 'App Environment',
    'App Secret' => 'App Secret',
    'Application layout' => 'Application layout',
    'Application theme' => 'Application theme',
    'Approve' => 'Approve',
    'Approved' => 'Approved',
    'Are you ready to take your' => 'Are you ready to take your',
    'Article details' => 'Article details',
    'Articles' => 'Articles',
    'Articles count' => 'Articles count',
    'Artists' => 'Artists',
    'Assigned events' => 'Assigned events',
    'Attendance' => 'Attendance',
    'Attendee' => 'Attendee',
    'Attendee / POS' => 'Attendee / POS',
    'Attendee Name / Email' => 'Attendee Name / Email',
    'Attendee Registration' => 'Attendee Registration',
    'Attendee information' => 'Attendee information',
    'Attendee name or email, ticket reference, order reference' => 'Attendee name or email, ticket reference, order reference',
    'Attendee status' => 'Attendee status',
    'Attendee tickets' => 'Attendee tickets',
    'Attendees' => 'Attendees',
    'Attendees Check In' => 'Attendees Check In',
    'Attendees check-in' => 'Attendees check-in',
    'Attendees list' => 'Attendees list',
    'Attendees reviews' => 'Attendees reviews',
    'Attendees summary' => 'Attendees summary',
    'Audience' => 'Audience',
    'Audiences' => 'Audiences',
    'Authentification Pages' => 'Authentication Pages',
    'Authorized' => 'Authorized',
    'Automatically canceled before deletion' => 'Automatically canceled before deletion',
    'Availability' => 'Availability',
    'Available languages' => 'Available languages',
    'Availibility' => 'Availibility',
    'Avatar' => 'Avatar',
    'Awaiting payment' => 'Awaiting payment',
    'Beschreibung' => 'Beschreibung',
    'Besides the qr code scanning feature, the scanner account will be able to check in the attendees using a list and a button' => 'Besides the qr code scanning feature, the scanner account will be able to check in the attendees using a list and a button',
    'Best regards, the %website_name% team' => 'Best regards, the %website_name% team',
    'Billing information' => 'Billing information',
    'Birthdate' => 'Birthdate',
    'Blog' => 'Blog',
    'Blog Pages' => 'Blog Pages',
    'Blog page' => 'Blog page',
    'Blog post' => 'Blog post',
    'Blog posts count' => 'Blog posts count',
    'Blog settings' => 'Blog settings',
    'Bought on' => 'Bought on',
    'Bought tickets' => 'Bought tickets',
    'Browse events' => 'Browse events',
    'Buy more tickets' => 'Buy more tickets',
    'Buy tickets' => 'Buy tickets',
    'By clicking on send, an email is going to be sent to the chosen email address. Make sure to save the configuration to be tested before testing.' => 'By clicking on send, an email is going to be sent to the chosen email address. Make sure to save the configuration to be tested before testing.',
    'By clicking the Sign Up button, I agree to' => 'By clicking the Sign Up button, I agree to',
    'CCY' => 'CCY',
    'Cancel' => 'Cancel',
    'Canceled' => 'Canceled',
    'Captured' => 'Captured',
    'Cart' => 'Cart',
    'Cart elements' => 'Cart elements',
    'Cash / Check / Bank Transfer / Other' => 'Cash / Check / Bank Transfer / Other',
    'Cash / Check / Offline' => 'Cash / Check / Offline',
    'Categories' => 'Categories',
    'Categories page' => 'Categories page',
    'Category' => 'Category',
    'Ccy' => 'Ccy',
    'Change password' => 'Change password',
    'Check In' => 'Check In',
    'Check In Attendees for this event date' => 'Check In Attendees for this event date',
    'Check your email inbox' => 'Check your email inbox',
    'Checked In At' => 'Checked In At',
    'Checked In Only' => 'Checked In Only',
    'Checkout' => 'Checkout',
    'Checkout settings' => 'Checkout settings',
    'Choose a new image to replace the old one' => 'Choose a new image to replace the old one',
    'Choose a payment gateway' => 'Choose a payment gateway',
    'Choose the link destination page' => 'Choose the link destination page',
    'Choose the right image to represent your event (We recommend using at least a 1200x600px (2:1 ratio) image )' => 'Choose the right image to represent your event (We recommend using at least a 1200x600px (2:1 ratio) image )',
    'City' => 'City',
    'Clear the application cache for the development environment' => 'Clear the application cache for the development environment',
    'Clear the application cache for the production environment' => 'Clear the application cache for the production environment',
    'Click here' => 'Click here',
    'Click on a date to view tickets' => 'Click on a date to view tickets',
    'Close' => 'Close',
    'Compact' => 'Compact',
    'Configuration' => 'Configuration',
    'Confirm' => 'Confirm',
    'Confirm account' => 'Confirm account',
    'Confirm payment and place order' => 'Confirm payment and place order',
    'Confirm payout request' => 'Confirm payout request',
    'Confirmation required' => 'Confirmation required',
    'Console' => 'Console',
    'Contact' => 'Contact',
    'Contact & Social media' => 'Contact & Social media',
    'Contact Us' => 'Contact Us',
    'Contact address' => 'Contact address',
    'Contact email' => 'Contact email',
    'Contact email address' => 'Contact email address',
    'Contact fax' => 'Contact fax',
    'Contact information' => 'Contact information',
    'Contact phone' => 'Contact phone',
    'Contact phone number' => 'Contact phone number',
    'Contact the attendee' => 'Contact the attendee',
    'Contact the organizer' => 'Contact the organizer',
    'Contact us' => 'Contact us',
    'Contenido' => 'Contenido',
    'Content' => 'Content',
    'Contente' => 'Contente',
    'Contenu' => 'Contenu',
    'Cookie policy' => 'Cookie policy',
    'Cookie policy page slug' => 'Cookie policy page slug',
    'Copyright' => 'Copyright',
    'Count' => 'Count',
    'Countries' => 'Countries',
    'Country' => 'Country',
    'Country code' => 'Country code',
    'Cover photo' => 'Cover photo',
    'Cover picture' => 'Cover picture',
    'Create Account' => 'Create Account',
    'Create an account' => 'Create an account',
    'Create event' => 'Create event',
    'Create my event' => 'Create my event',
    'Created by organizer' => 'Created by organizer',
    'Creation date' => 'Creation date',
    'Creation date / Last login' => 'Creation date / Last login',
    'Credit or debit card' => 'Credit or debit card',
    'Currency' => 'Currency',
    'Currency symbol' => 'Currency symbol',
    'Currency symbol position' => 'Currency symbol position',
    'Currently in cart' => 'Currently in cart',
    'Custom css' => 'Custom css',
    'Custom hero' => 'Custom hero',
    'Custom hero background image' => 'Custom hero background image',
    'Custom hero title and paragraph translation' => 'Custom hero title and paragraph translation',
    'Custom link' => 'Custom link',
    'Dark' => 'Dark',
    'Dark blue' => 'Dark blue',
    'Dashboard' => 'Dashboard',
    'Dashboard Pages' => 'Dashboard Pages',
    'Date' => 'Date',
    'Date and time format' => 'Date and time format',
    'Date only format' => 'Date only format',
    'Dates' => 'Dates',
    'Default language' => 'Default language',
    'Delete' => 'Delete',
    'Delete permanently' => 'Delete permanently',
    'Deleted' => 'Deleted',
    'Deletion date' => 'Deletion date',
    'Descripción' => 'Descripción',
    'Description' => 'Description',
    'Descrição' => 'Descrição',
    'Details' => 'Details',
    'Development' => 'Development',
    'Development environment is used for development purposes only' => 'Development environment is used for development purposes only',
    'Disable' => 'Disable',
    'Disabled' => 'Disabled',
    'Disabled only' => 'Disabled only',
    'Display itinerary bicycling' => 'Display itinerary bicycling',
    'Display itinerary driving' => 'Display itinerary driving',
    'Display itinerary on public transportation' => 'Display itinerary on public transportation',
    'Display itinerary walking' => 'Display itinerary walking',
    'Display top 4 featured categories (footer section menu only)' => 'Display top 4 featured categories (footer section menu only)',
    'Disqus comments' => 'Disqus comments',
    'Disqus subdomain' => 'Disqus subdomain',
    'Draft' => 'Draft',
    'Draft only' => 'Draft only',
    'Early bird, General admission, VIP...' => 'Early bird, General admission, VIP...',
    'Edit' => 'Edit',
    'Edit the menu' => 'Edit the menu',
    'Edit your organizer profile' => 'Edit your organizer profile',
    'Editing the title after the event is saved won\'t change the event url' => 'Editing the title after the event is saved won\'t change the event url',
    'Elapsed only' => 'Elapsed only',
    'Elements' => 'Elements',
    'Email' => 'Email',
    'Email address' => 'Email address',
    'Empty cart' => 'Empty cart',
    'En cabeza' => 'En cabeza',
    'En-tête' => 'En-tête',
    'Enable' => 'Enable',
    'Enable Facebook Social Login' => 'Enable Facebook Social Login',
    'Enable Google Repatcha' => 'Enable Google Repatcha',
    'Enable Google Social Login' => 'Enable Google Social Login',
    'Enable comments' => 'Enable comments',
    'Enable maintenance mode to display a maintenance page for all users but the users who are granted the ROLE_ADMINISTRATOR role, if you lost your session, you can edit the MAINTENANCE_MODE parameter directly in the .env file' => 'Enable maintenance mode to display a maintenance page for all users but the users who are granted the ROLE_ADMINISTRATOR role, if you lost your session, you can edit the MAINTENANCE_MODE parameter directly in the .env file',
    'Enable newsletter' => 'Enable newsletter',
    'Enable reviews' => 'Enable reviews',
    'Enable sales for this event date ?' => 'Enable sales for this event date ?',
    'Enable sales for this ticket ?' => 'Enable sales for this ticket ?',
    'Enable to display stacktraces on error pages or if cache files should be dynamically rebuilt on each request' => 'Enable to display stacktraces on error pages or if cache files should be dynamically rebuilt on each request',
    'Enabled' => 'Enabled',
    'Enabled only' => 'Enabled only',
    'Enabling sales for an event date does not affect the tickets individual sale status' => 'Enabling sales for an event date does not affect the tickets individual sale status',
    'Encryption' => 'Encryption',
    'End date' => 'End date',
    'Ends On' => 'Ends On',
    'Enlarge' => 'Enlarge',
    'Enter the chosen primary color code (i.e #ffffff)' => 'Enter the chosen primary color code (i.e #ffffff)',
    'Enter the chosen website name with no spaces and no uppercase characters (for SEO purposes)' => 'Enter the chosen website name with no spaces and no uppercase characters (for SEO purposes)',
    'Enter the email address to be reached for inquiries' => 'Enter the email address to be reached for inquiries',
    'Enter the full website url' => 'Enter the full website url',
    'Enter the list of artists that will perform in your event (press Enter after each entry)' => 'Enter the list of artists that will perform in your event (press Enter after each entry)',
    'Enter the phone number to be called for inquiries' => 'Enter the phone number to be called for inquiries',
    'Enter the website url without http nor https' => 'Enter the website url without http nor https',
    'Enter the website url without http nor https, Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Enter the website url without http nor https, Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle',
    'Error' => 'Error',
    'Etiquetas' => 'Etiquetas',
    'Event' => 'Event',
    'Event / Ticket' => 'Event / Ticket',
    'Event Categories' => 'Event Categories',
    'Event already started' => 'Event already started',
    'Event categories' => 'Event categories',
    'Event date' => 'Event date',
    'Event date is disabled' => 'Event date is disabled',
    'Event date status' => 'Event date status',
    'Event dates' => 'Event dates',
    'Event details' => 'Event details',
    'Event is not published' => 'Event is not published',
    'Event list' => 'Event list',
    'Event ticket' => 'Event ticket',
    'Event ticket is disabled' => 'Event ticket is disabled',
    'Event ticket status' => 'Event ticket status',
    'Event tickets' => 'Event tickets',
    'Event views' => 'Event views',
    'Events' => 'Events',
    'Events Pages' => 'Events Pages',
    'Events RSS feed' => 'Events RSS feed',
    'Events added' => 'Events added',
    'Events count' => 'Events count',
    'Events in %countryname%' => 'Events in %countryname%',
    'Events list' => 'Events list',
    'Events list page' => 'Events list page',
    'Events list page settings' => 'Events list page settings',
    'Events on sale' => 'Events on sale',
    'Events page' => 'Events page',
    'Events slider' => 'Events slider',
    'Events summary' => 'Events summary',
    'Execute Symfony commands' => 'Execute Symfony commands',
    'Execute command' => 'Execute command',
    'Execute this command after editing a file in the application source code or after modifying a string in the translations files' => 'Execute this command after editing a file in the application source code or after modifying a string in the translations files',
    'Execute this command if you are in the development mode and the modifications you applied in the application did take effect' => 'Execute this command if you are in the development mode and the modifications you applied in the application did take effect',
    'Explore' => 'Explore',
    'Explore events' => 'Explore events',
    'Export attendees list to a PDF file' => 'Export attendees list to a PDF file',
    'Export current orders to a CSV file' => 'Export current orders to a CSV file',
    'Export current orders to an Excel file' => 'Export current orders to an Excel file',
    'External link' => 'External link',
    'FAQ' => 'FAQ',
    'Facebook' => 'Facebook',
    'Facebook Id' => 'Facebook Id',
    'Facebook Secret' => 'Facebook Secret',
    'Facebook app id' => 'Facebook app id',
    'Facebook comments' => 'Facebook comments',
    'Facebook profile picture' => 'Facebook profile picture',
    'Facebook url' => 'Facebook url',
    'Failed' => 'Failed',
    'Favicon' => 'Favicon',
    'Favorites' => 'Favorites',
    'Fax' => 'Fax',
    'Featured' => 'Featured',
    'Featured categories' => 'Featured categories',
    'Featured only' => 'Featured only',
    'Featured order' => 'Featured order',
    'Fees' => 'Fees',
    'Fees & Taxes' => 'Fees & Taxes',
    'First Name' => 'First Name',
    'First name' => 'First name',
    'Flag' => 'Flag',
    'Fluid' => 'Fluid',
    'Follow' => 'Follow',
    'Followed by' => 'Followed by',
    'Followers' => 'Followers',
    'Following' => 'Following',
    'Food and beverage' => 'Food and beverage',
    'Food and beverage details' => 'Food and beverage details',
    'For \'Cash / Check / Bank Transfer / Other\', the order will remain on the \'Awaiting payment\' status until the organizer or the administrator approves it' => 'For \'Cash / Check / Bank Transfer / Other\', the order will remain on the \'Awaiting payment\' status until the organizer or the administrator approves it',
    'Forbidden' => 'Forbidden',
    'Forgot your password ?' => 'Forgot your password ?',
    'Free' => 'Free',
    'Free events only' => 'Free events only',
    'From date' => 'From date',
    'Full name' => 'Full name',
    'GDPR compliance' => 'GDPR compliance',
    'Gallery' => 'Gallery',
    'Gallery image' => 'Gallery image',
    'Gdpr compliance page slug' => 'Gdpr compliance page slug',
    'Gender' => 'Gender',
    'General information' => 'General information',
    'Generation date' => 'Generation date',
    'Global payment settings' => 'Global payment settings',
    'Gmail' => 'Gmail',
    'Go back' => 'Go back',
    'Go to the Pages section in the settings to add a new page' => 'Go to the Pages section in the settings to add a new page',
    'Go to the documentation to get help about getting a list id' => 'Go to the documentation to get help about getting a list id',
    'Go to the documentation to get help about getting an api key' => 'Go to the documentation to get help about getting an api key',
    'Go to the documentation to get help about getting an app ID' => 'Go to the documentation to get help about getting an app ID',
    'Go to the documentation to get help about setting up Disqus' => 'Go to the documentation to get help about setting up Disqus',
    'Google Id' => 'Google Id',
    'Google Maps' => 'Google Maps',
    'Google Maps Api Key' => 'Google Maps Api Key',
    'Google Maps settings' => 'Google Maps settings',
    'Google Plus' => 'Google Plus',
    'Google Recaptcha' => 'Google Recaptcha',
    'Google Recaptcha settings' => 'Google Recaptcha settings',
    'Google Secret' => 'Google Secret',
    'Google analytics Tracking ID' => 'Google analytics Tracking ID',
    'Google analytics code' => 'Google analytics code',
    'Google plus' => 'Google plus',
    'Green' => 'Green',
    'Gross Sales' => 'Gross Sales',
    'Gross sales' => 'Gross sales',
    'Gross sales by channel' => 'Gross sales by channel',
    'Gross sales per Point of sale' => 'Gross sales per Point of sale',
    'Guests' => 'Guests',
    'Header' => 'Header',
    'Header text' => 'Header text',
    'Help Center Article' => 'Help Center Article',
    'Help Center Category' => 'Help Center Category',
    'Help Center Pages' => 'Help Center Pages',
    'Help Center page' => 'Help Center page',
    'Help center' => 'Help center',
    'Here are the details' => 'Here are the details',
    'Hey' => 'Hey',
    'Hidden' => 'Hidden',
    'Hidden only' => 'Hidden only',
    'Hide' => 'Hide',
    'Hide from public directory' => 'Hide from public directory',
    'Hide slider' => 'Hide slider',
    'Home' => 'Home',
    'Homepage' => 'Homepage',
    'Homepage content settings' => 'Homepage content settings',
    'Homepage hero settings' => 'Homepage hero settings',
    'Homepage settings' => 'Homepage settings',
    'Host' => 'Host',
    'How can we help?' => 'How can we help?',
    'How it works' => 'How it works',
    'Icon' => 'Icon',
    'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M' => 'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M',
    'If you need to send the confirmation email to a different email address, you can change it before submitting' => 'If you need to send the confirmation email to a different email address, you can change it before submitting',
    'If your event has a dedicated website, enter its url here' => 'If your event has a dedicated website, enter its url here',
    'If your event is a movie for example, select the available subtitles' => 'If your event is a movie for example, select the available subtitles',
    'If your event is a movie for example, select the year of release' => 'If your event is a movie for example, select the year of release',
    'Image' => 'Image',
    'Images' => 'Images',
    'Images gallery' => 'Images gallery',
    'Impersonate' => 'Impersonate',
    'In' => 'In',
    'In deinen Gedanken' => 'In deinen Gedanken',
    'Information not provided' => 'Information not provided',
    'Information provided' => 'Information provided',
    'Inhalt' => 'Inhalt',
    'Insert at least 3 characters' => 'Insert at least 3 characters',
    'Instagram' => 'Instagram',
    'Instagram url' => 'Instagram url',
    'Instrucciones' => 'Instrucciones',
    'Instructions' => 'Instructions',
    'Instruções' => 'Instruções',
    'Invalid credentials' => 'Invalid credentials',
    'Is featured' => 'Is featured',
    'Is featured on the homepage slider?' => 'Is featured on the homepage slider?',
    'Is this event date online ?' => 'Is this event date online ?',
    'Is this ticket free ?' => 'Is this ticket free ?',
    'It wasn\'t possible to retrieve information about the provided IP' => 'It wasn\'t possible to retrieve information about the provided IP',
    'Keyword' => 'Keyword',
    'Language' => 'Language',
    'Language code' => 'Language code',
    'Languages' => 'Languages',
    'Last Name' => 'Last Name',
    'Last login' => 'Last login',
    'Last name' => 'Last name',
    'Last updated' => 'Last updated',
    'Lastest blog posts' => 'Lastest blog posts',
    'Layout settings' => 'Layout settings',
    'Layout, parameters and SEO' => 'Layout, parameters and SEO',
    'Leave a review' => 'Leave a review',
    'Leave api key empty to disable google maps project wide' => 'Leave api key empty to disable google maps project wide',
    'Leave the password empty to keep the old one' => 'Leave the password empty to keep the old one',
    'Left' => 'Left',
    'Let the other attendee know more details about your experience' => 'Let the other attendee know more details about your experience',
    'Light blue' => 'Light blue',
    'Link' => 'Link',
    'Link Text' => 'Link Text',
    'Link text' => 'Link text',
    'LinkedIn' => 'LinkedIn',
    'Linkedin' => 'Linkedin',
    'List on public directory' => 'List on public directory',
    'Listed on directory' => 'Listed on directory',
    'Listed on the directory' => 'Listed on the directory',
    'Load more' => 'Load more',
    'Loading...' => 'Loading...',
    'Local events only' => 'Local events only',
    'Location' => 'Location',
    'Locked (Payout request approved)' => 'Locked (Payout request approved)',
    'Locked (Payout request pending)' => 'Locked (Payout request pending)',
    'Login' => 'Login',
    'Logo' => 'Logo',
    'Looking for' => 'Looking for',
    'Mail server' => 'Mail server',
    'Mail server settings' => 'Mail server settings',
    'Mail server test email' => 'Mail server test email',
    'Mailchimp app id' => 'Mailchimp app id',
    'Mailchimp list id' => 'Mailchimp list id',
    'Main blog post image' => 'Main blog post image',
    'Main categories' => 'Main categories',
    'Main event image' => 'Main event image',
    'Main image' => 'Main image',
    'Maintenance mode' => 'Maintenance mode',
    'Maintenance mode custom message' => 'Maintenance mode custom message',
    'Make sure that the added payment gateways are configured to support this currency' => 'Make sure that the added payment gateways are configured to support this currency',
    'Make sure that the currency setting of your payout method matches the one currently used which is %currency%' => 'Make sure that the currency setting of your payout method matches the one currently used which is %currency%',
    'Make sure to enter a valid email address' => 'Make sure to enter a valid email address',
    'Make sure to select organizers who have added a cover photo' => 'Make sure to select organizers who have added a cover photo',
    'Make sure to select right category to let the users find it quickly' => 'Make sure to select right category to let the users find it quickly',
    'Manage amenities' => 'Manage amenities',
    'Manage articles' => 'Manage articles',
    'Manage attendees' => 'Manage attendees',
    'Manage audiences' => 'Manage audiences',
    'Manage blog' => 'Manage blog',
    'Manage blog post categories' => 'Manage blog post categories',
    'Manage blog posts' => 'Manage blog posts',
    'Manage categories' => 'Manage categories',
    'Manage countries' => 'Manage countries',
    'Manage currencies' => 'Manage currencies',
    'Manage event' => 'Manage event',
    'Manage events' => 'Manage events',
    'Manage help center' => 'Manage help center',
    'Manage help center articles' => 'Manage help center articles',
    'Manage help center categories' => 'Manage help center categories',
    'Manage languages' => 'Manage languages',
    'Manage menus' => 'Manage menus',
    'Manage orders' => 'Manage orders',
    'Manage pages' => 'Manage pages',
    'Manage posts' => 'Manage posts',
    'Manage reviews' => 'Manage reviews',
    'Manage users' => 'Manage users',
    'Manage venues' => 'Manage venues',
    'Manage venues amenities' => 'Manage venues amenities',
    'Manage venues types' => 'Manage venues types',
    'Manage website translation' => 'Manage website translation',
    'Mark as featured' => 'Mark as featured',
    'Mark as not featured' => 'Mark as not featured',
    'Max' => 'Max',
    'Member since' => 'Member since',
    'Menu elements' => 'Menu elements',
    'Menu name' => 'Menu name',
    'Menus' => 'Menus',
    'Menus settings' => 'Menus settings',
    'Menüname' => 'Menüname',
    'Message' => 'Message',
    'Message from the attendee:' => 'Message from the attendee:',
    'Method Not Supported' => 'Method Not Supported',
    'Min' => 'Min',
    'More details' => 'More details',
    'More information' => 'More information',
    'Mots clés' => 'Mots clés',
    'My Account' => 'My Account',
    'My cart' => 'My cart',
    'My events' => 'My events',
    'My favorites' => 'My favorites',
    'My orders' => 'My orders',
    'My organizer profile' => 'My organizer profile',
    'My points of sale' => 'My points of sale',
    'My review' => 'My review',
    'My reviews' => 'My reviews',
    'My scanners' => 'My scanners',
    'My tickets' => 'My tickets',
    'My venues' => 'My venues',
    'N/A' => 'N/A',
    'Na sua mente' => 'Na sua mente',
    'Name' => 'Name',
    'Name / Username' => 'Name / Username',
    'Native comments' => 'Native comments',
    'Neighborhoods' => 'Neighborhoods',
    'Net sales' => 'Net sales',
    'Net sales until' => 'Net sales until',
    'New' => 'New',
    'New message regarding the order' => 'New message regarding the order',
    'New payout request' => 'New payout request',
    'New quote request' => 'New quote request',
    'Newsletter' => 'Newsletter',
    'Newsletter settings' => 'Newsletter settings',
    'Next month' => 'Next month',
    'Next week' => 'Next week',
    'No' => 'No',
    'No amenites found' => 'No amenites found',
    'No articles found' => 'No articles found',
    'No attendees found' => 'No attendees found',
    'No audiences found' => 'No audiences found',
    'No blog post categories found' => 'No blog post categories found',
    'No blog posts found' => 'No blog posts found',
    'No categories found' => 'No categories found',
    'No countries found' => 'No countries found',
    'No currencies found' => 'No currencies found',
    'No event dates found' => 'No event dates found',
    'No events found' => 'No events found',
    'No events on sale' => 'No events on sale',
    'No events on sale for now' => 'No events on sale for now',
    'No languages found' => 'No languages found',
    'No link, display featured categories dropdown on hover (header menu only)' => 'No link, display featured categories dropdown on hover (header menu only)',
    'No menus found' => 'No menus found',
    'No orders found' => 'No orders found',
    'No orders found to be included in the report' => 'No orders found to be included in the report',
    'No pages found' => 'No pages found',
    'No past events found' => 'No past events found',
    'No payment gateways are currently enabled' => 'No payment gateways are currently enabled',
    'No payment gateways found' => 'No payment gateways found',
    'No payout requests found' => 'No payout requests found',
    'No points of sale found' => 'No points of sale found',
    'No reply email address' => 'No reply email address',
    'No results found' => 'No results found',
    'No review found' => 'No review found',
    'No reviews found' => 'No reviews found',
    'No sales yet' => 'No sales yet',
    'No scanners found' => 'No scanners found',
    'No ticket on sale' => 'No ticket on sale',
    'No tickets found' => 'No tickets found',
    'No tickets selected to add to cart' => 'No tickets selected to add to cart',
    'No users found' => 'No users found',
    'No venue types found' => 'No venue types found',
    'No venues found' => 'No venues found',
    'Nom' => 'Nom',
    'Nom du menu' => 'Nom du menu',
    'Nombre' => 'Nombre',
    'Nombre du menú' => 'Nombre du menú',
    'Nome' => 'Nome',
    'Nome do menu' => 'Nome do menu',
    'None' => 'None',
    'Not Checked In Only' => 'Not Checked In Only',
    'Not a member yet ?' => 'Not a member yet ?',
    'Not elapsed only' => 'Not elapsed only',
    'Not featured' => 'Not featured',
    'Not listed on the directory' => 'Not listed on the directory',
    'Note' => 'Note',
    'Number of blog posts per page' => 'Number of blog posts per page',
    'Number of blog posts to show' => 'Number of blog posts to show',
    'Number of events per page' => 'Number of events per page',
    'Number of events to show' => 'Number of events to show',
    'Number of featured categories to show' => 'Number of featured categories to show',
    'Number of guests' => 'Number of guests',
    'Number of seconds before the reserved tickets are released if the order is still awaiting payment' => 'Number of seconds before the reserved tickets are released if the order is still awaiting payment',
    'Number of tickets' => 'Number of tickets',
    'OR' => 'OR',
    'On sale' => 'On sale',
    'Once the payout request submitted, the event date will be locked and the sales will be suspended for the specific event date. If you wish, you can wait until the start date of the event date before requesting the payout. You can cancel the payout request any time before it is processed' => 'Once the payout request submitted, the event date will be locked and the sales will be suspended for the specific event date. If you wish, you can wait until the start date of the event date before requesting the payout. You can cancel the payout request any time before it is processed',
    'Online' => 'Online',
    'Online events only' => 'Online events only',
    'Optional attendee information' => 'Optional attendee information',
    'Optionally add a cover photo to showcase your organizer activities' => 'Optionally add a cover photo to showcase your organizer activities',
    'Orange' => 'Orange',
    'Order' => 'Order',
    'Order =' => 'Order',
    'Order = ' => 'Order = ',
    'Order Date' => 'Order Date',
    'Order confirmation' => 'Order confirmation',
    'Order date' => 'Order date',
    'Order details' => 'Order details',
    'Order of appearance' => 'Order of appearance',
    'Order payment details' => 'Order payment details',
    'Order reference' => 'Order reference',
    'Order status' => 'Order status',
    'Order summary' => 'Order summary',
    'Order total' => 'Order total',
    'Orders' => 'Orders',
    'Orders placed' => 'Orders placed',
    'Orders summary' => 'Orders summary',
    'Organizer' => 'Organizer',
    'Organizer / Event / Date / Ticket' => 'Organizer / Event / Date / Ticket',
    'Organizer Profile' => 'Organizer Profile',
    'Organizer Registration' => 'Organizer Registration',
    'Organizer information' => 'Organizer information',
    'Organizer is disabled' => 'Organizer is disabled',
    'Organizer logo' => 'Organizer logo',
    'Organizer name' => 'Organizer name',
    'Organizer profile' => 'Organizer profile',
    'Organizer revenue from %website_name%' => 'Organizer revenue from %website_name%',
    'Organizers' => 'Organizers',
    'Organizers Pages' => 'Organizers Pages',
    'Organizers slider' => 'Organizers slider',
    'Organizers, attendees, this support center is intended to quickly reply to your questions, if still don\'t find answers, please contact us, w e will be happy to receive your inquiry' => 'Organizers, attendees, this support center is intended to quickly reply to your questions, if still don\'t find answers, please contact us, w e will be happy to receive your inquiry',
    'Other events by %organizername%' => 'Other events by %organizername%',
    'PERMANENTLY' => 'PERMANENTLY',
    'POS' => 'POS',
    'Page content' => 'Page content',
    'Page not found' => 'Page not found',
    'Pages' => 'Pages',
    'Paid' => 'Paid',
    'Paid orders' => 'Paid orders',
    'Palabras clave' => 'Palabras clave',
    'Palavras-chave' => 'Palavras-chave',
    'Paragraph' => 'Paragraph',
    'Paragraphe' => 'Paragraphe',
    'Parent' => 'Parent',
    'Parent category' => 'Parent category',
    'Parágrafo' => 'Parágrafo',
    'Password' => 'Password',
    'Password Resetting' => 'Password Resetting',
    'Past events' => 'Past events',
    'Past tickets' => 'Past tickets',
    'Pay now' => 'Pay now',
    'Payment' => 'Payment',
    'Payment details' => 'Payment details',
    'Payment gateways' => 'Payment gateways',
    'Payment method' => 'Payment method',
    'Payment of tickets purchased on %website_name%' => 'Payment of tickets purchased on %website_name%',
    'Payment settings' => 'Payment settings',
    'Payments and Fees' => 'Payments and Fees',
    'Payout already requested' => 'Payout already requested',
    'Payout method' => 'Payout method',
    'Payout methods' => 'Payout methods',
    'Payout request' => 'Payout request',
    'Payout request details' => 'Payout request details',
    'Payout request notification' => 'Payout request notification',
    'Payout request payment details' => 'Payout request payment details',
    'Payout requests' => 'Payout requests',
    'Payouts' => 'Payouts',
    'Paypal Client Id' => 'Paypal Client Id',
    'Paypal Client Secret' => 'Paypal Client Secret',
    'Paypal Express Checkout' => 'Paypal Express Checkout',
    'Pending' => 'Pending',
    'Pending payout requests' => 'Pending payout requests',
    'Percentage cut' => 'Percentage cut',
    'Phone' => 'Phone',
    'Phone number' => 'Phone number',
    'Photos' => 'Photos',
    'Pick a date' => 'Pick a date',
    'Pink' => 'Pink',
    'Please choose a 200x200 minimum image size as it is required by Facebook' => 'Please choose a 200x200 minimum image size as it is required by Facebook',
    'Please choose a 200x50 image size to ensure compatibility with the website design' => 'Please choose a 200x50 image size to ensure compatibility with the website design',
    'Please choose a 200x50 image to ensure compatibility with the website design' => 'Please choose a 200x50 image to ensure compatibility with the website design',
    'Please click on the following link to check the status of your request' => 'Please click on the following link to check the status of your request',
    'Please confirm your account by clicking the link below' => 'Please confirm your account by clicking the link below',
    'Please enter the selected payment gateway details' => 'Please enter the selected payment gateway details',
    'Please enter the subject carefully in order get the help you need' => 'Please enter the subject carefully in order get the help you need',
    'Please enter your payout method details' => 'Please enter your payout method details',
    'Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle',
    'Please refer to this following list and use the Code column: https://en.wikipedia.org/wiki/ISO_4217' => 'Please refer to thefollowing list and use the Code column: https://en.wikipedia.org/wiki/ISO_4217',
    'Please select the tickets quantity for this order' => 'Please select the tickets quantity for this order',
    'Please select the tickets quantity you want to buy' => 'Please select the tickets quantity you want to buy',
    'Please set a payout method before submitting a payout request' => 'Please set a payout method before submitting a payout request',
    'Please wait a few seconds if the translation interface freezes at page load' => 'Please wait a few seconds if the translation interface freezes at page load',
    'Please wait a few seconds if the translation interface freezes at page load, or edit the files in translations/ folder at root of the project directly in your favorite text editor' => 'Please wait a few seconds if the translation interface freezes at page load, or edit the files in translations/ folder at root of the project directly in your favorite text editor',
    'Point of sale' => 'Point of sale',
    'Point of sale information' => 'Point of sale information',
    'Point of sales' => 'Point of sales',
    'Points of sale' => 'Points of sale',
    'Popular' => 'Popular',
    'Popularity' => 'Popularity',
    'Port' => 'Port',
    'Position' => 'Position',
    'Postal code' => 'Postal code',
    'Posts' => 'Posts',
    'Price' => 'Price',
    'Pricing' => 'Pricing',
    'Pricing and fees' => 'Pricing and fees',
    'Primary color code' => 'Primary color code',
    'Print tickets' => 'Print tickets',
    'Privacy policy' => 'Privacy policy',
    'Privacy policy page slug' => 'Privacy policy page slug',
    'Processed' => 'Processed',
    'Processed at' => 'Processed at',
    'Processing date' => 'Processing date',
    'Production' => 'Production',
    'Profile picture' => 'Profile picture',
    'Profile views' => 'Profile views',
    'Project wide date and time format, follow this link for a list of supported characters: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string' => 'Project wide date and time format, follow this link for a list of supported characters: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string',
    'Promotional price' => 'Promotional price',
    'Publicly show attendees' => 'Publicly show attendees',
    'Publish' => 'Publish',
    'Published events' => 'Published events',
    'Published only' => 'Published only',
    'Purple' => 'Purple',
    'Párrafo' => 'Párrafo',
    'Quantity' => 'Quantity',
    'Rating' => 'Rating',
    'Read more' => 'Read more',
    'Read time in minutes' => 'Read time in minutes',
    'Recent orders' => 'Recent orders',
    'Red' => 'Red',
    'Reference' => 'Reference',
    'Refund' => 'Refund',
    'Refund requested' => 'Refund requested',
    'Refunded' => 'Refunded',
    'Register' => 'Register',
    'Register attendees' => 'Register attendees',
    'Registered using Facebook' => 'Registered using Facebook',
    'Registered using Google' => 'Registered using Google',
    'Registration date' => 'Registration date',
    'Related posts' => 'Related posts',
    'Remove' => 'Remove',
    'Remove from favorites' => 'Remove from favorites',
    'Repeat password' => 'Repeat password',
    'Reports' => 'Reports',
    'Request a quote' => 'Request a quote',
    'Request date' => 'Request date',
    'Request payout' => 'Request payout',
    'Requested at' => 'Requested at',
    'Resend confirmation email' => 'Resend confirmation email',
    'Reset' => 'Reset',
    'Reset your password' => 'Reset your password',
    'Response' => 'Response',
    'Restore' => 'Restore',
    'Return to cart' => 'Return to cart',
    'Review date' => 'Review date',
    'Review(s)' => 'Review(s)',
    'Reviews' => 'Reviews',
    'Reviews for %eventname%' => 'Reviews for %eventname%',
    'Right' => 'Right',
    'Role' => 'Role',
    'SEO keywords' => 'SEO keywords',
    'SMTP' => 'SMTP',
    'SSL' => 'SSL',
    'SSL must be activated on your hosting server in order to use Mailchimp' => 'SSL must be activated on your hosting server in order to use Mailchimp',
    'Sale didn\'t start yet' => 'Sale didn\'t start yet',
    'Sale ended' => 'Sale ended',
    'Sale ends On' => 'Sale ends On',
    'Sale starts On' => 'Sale starts On',
    'Sales' => 'Sales',
    'Sales channel' => 'Sales channel',
    'Sales end' => 'Sales end',
    'Sales end date' => 'Sales end date',
    'Sales end in' => 'Sales end in',
    'Sales ended' => 'Sales ended',
    'Sales ended on' => 'Sales ended on',
    'Sales start date' => 'Sales start date',
    'Sales start in' => 'Sales start in',
    'Sales started' => 'Sales started',
    'Sales started on' => 'Sales started on',
    'Sandbox' => 'Sandbox',
    'Save' => 'Save',
    'Save order' => 'Save order',
    'Scanned tickets' => 'Scanned tickets',
    'Scanner' => 'Scanner',
    'Scanner App' => 'Scanner App',
    'Scanner App settings' => 'Scanner App settings',
    'Scanner information' => 'Scanner information',
    'Scanners' => 'Scanners',
    'Schlüsselwörter' => 'Schlüsselwörter',
    'Search' => 'Search',
    'Search blog' => 'Search blog',
    'Search blog posts' => 'Search blog posts',
    'Search for answers' => 'Search for answers',
    'Search for events' => 'Search for events',
    'Search help center' => 'Search help center',
    'Search in reviews' => 'Search in reviews',
    'Searching ...' => 'Searching ...',
    'Seated' => 'Seated',
    'Seated guests' => 'Seated guests',
    'Seated guests number' => 'Seated guests number',
    'Secret key' => 'Secret key',
    'See all' => 'See all',
    'See all %reviewscount% reviews' => 'See all %reviewscount% reviews',
    'See all categories' => 'See all categories',
    'See all events on sale' => 'See all events on sale',
    'See more articles' => 'See more articles',
    'See more events' => 'See more events',
    'Select a payout method' => 'Select a payout method',
    'Select a specific event date' => 'Select a specific event date',
    'Select a specific event ticket' => 'Select a specific event ticket',
    'Select an option' => 'Select an option',
    'Select parent of \'Point of sale\' or \'Scanner\'' => 'Select parent of \'Point of sale\' or \'Scanner\'',
    'Select the audience types that are targeted in your event' => 'Select the audience types that are targeted in your event',
    'Select the categories that represent your events types' => 'Select the categories that represent your events types',
    'Select the country that your event represents (ie: A movie\'s country of production)' => 'Select the country that your event represents (ie: A movie\'s country of production)',
    'Select the languages that will be spoken in your event' => 'Select the languages that will be spoken in your event',
    'Select the parent category to add a sub category' => 'Select the parent category to add a sub category',
    'Sell tickets online' => 'Sell tickets online',
    'Send' => 'Send',
    'Send us an email' => 'Send us an email',
    'Sendmail' => 'Sendmail',
    'Set' => 'Set',
    'Set a new password' => 'Set a new password',
    'Set a price lesser than than the original price to indicate a promotion (this price will be the SALE price)' => 'Set a price lesser than than the original price to indicate a promotion (this price will be the SALE price)',
    'Set the display order for the featured categories' => 'Set the display order for the featured categories',
    'Set the number of tickets that an attendee can buy for this ticket type' => 'Set the number of tickets that an attendee can buy for this ticket type',
    'Set the parent category to add a subcategory' => 'Set the parent category to add a subcategory',
    'Set your %payoutMethodName% payout method' => 'Set your %payoutMethodName% payout method',
    'Settings' => 'Settings',
    'Share' => 'Share',
    'Show' => 'Show',
    'Show RSS feed button' => 'Show RSS feed button',
    'Show a map at the bottom of your organizer profile page containing the venues you added' => 'Show a map at the bottom of your organizer profile page containing the venues you added',
    'Show audience filter' => 'Show audience filter',
    'Show calendar button' => 'Show calendar button',
    'Show category filter' => 'Show category filter',
    'Show date filter' => 'Show date filter',
    'Show event date stats on the scanner app' => 'Show event date stats on the scanner app',
    'Show event dates and tickets' => 'Show event dates and tickets',
    'Show events calendar' => 'Show events calendar',
    'Show events on map' => 'Show events on map',
    'Show followers' => 'Show followers',
    'Show location filter' => 'Show location filter',
    'Show map button' => 'Show map button',
    'Show reviews' => 'Show reviews',
    'Show the GDPR compliance page link' => 'Show the GDPR compliance page link',
    'Show the attendees number and list in the event page' => 'Show the attendees number and list in the event page',
    'Show the back to top button' => 'Show the back to top button',
    'Show the call to action block' => 'Show the call to action block',
    'Show the cookie policy bar at the bottom' => 'Show the cookie policy bar at the bottom',
    'Show the cookie policy page link' => 'Show the cookie policy page link',
    'Show the homepage hero seach box' => 'Show the homepage hero seach box',
    'Show the map along with the address on the venue page and event page' => 'Show the map along with the address on the venue page and event page',
    'Show the number and list of people that follow you' => 'Show the number and list of people that follow you',
    'Show the privacy policy page link' => 'Show the privacy policy page link',
    'Show the quote form on the venue page' => 'Show the quote form on the venue page',
    'Show the reviews that you received for your events' => 'Show the reviews that you received for your events',
    'Show the search box' => 'Show the search box',
    'Show the terms of service page link' => 'Show the terms of service page link',
    'Show ticket price filter' => 'Show ticket price filter',
    'Show tickets left count on cart modal' => 'Show tickets left count on cart modal',
    'Show venues map' => 'Show venues map',
    'Sign in' => 'Sign in',
    'Sign in via Facebook' => 'Sign in via Facebook',
    'Sign in via Google' => 'Sign in via Google',
    'Sign in via Twitter' => 'Sign in via Twitter',
    'Sign out' => 'Sign out',
    'Sign up' => 'Sign up',
    'Sign up via Facebook' => 'Sign up via Facebook',
    'Sign up via Google' => 'Sign up via Google',
    'Sign up via Twitter' => 'Sign up via Twitter',
    'Similar events' => 'Similar events',
    'Site key' => 'Site key',
    'Sitemap' => 'Sitemap',
    'Slug' => 'Slug',
    'Social Login' => 'Social Login',
    'Social Login settings' => 'Social Login settings',
    'Social media share image' => 'Social media share image',
    'Sold out' => 'Sold out',
    'Sort by' => 'Sort by',
    'Standing' => 'Standing',
    'Standing guests' => 'Standing guests',
    'Standing guests number' => 'Standing guests number',
    'Start date' => 'Start date',
    'Starts On' => 'Starts On',
    'State' => 'State',
    'State / City' => 'State / City',
    'Static Pages' => 'Static Pages',
    'Static pages settings' => 'Static pages settings',
    'Statistics' => 'Statistics',
    'Status' => 'Status',
    'Stick' => 'Stick',
    'Still in cart' => 'Still in cart',
    'Street' => 'Street',
    'Street 2' => 'Street 2',
    'Street address' => 'Street address',
    'Street address 2' => 'Street address 2',
    'Stripe Checkout' => 'Stripe Checkout',
    'Stripe Checkout (credit cards)' => 'Stripe Checkout (credit cards)',
    'Stripe payout' => 'Stripe payout',
    'Stripe publishable key' => 'Stripe publishable key',
    'Stripe secret key' => 'Stripe secret key',
    'Subject' => 'Subject',
    'Submit payment' => 'Submit payment',
    'Subscribe' => 'Subscribe',
    'Subscribe to our newsletter' => 'Subscribe to our newsletter',
    'Subtitles' => 'Subtitles',
    'Subtotal' => 'Subtotal',
    'Successfully executed the command' => 'Successfully executed the command',
    'Support for' => 'Support for',
    'Suspended' => 'Suspended',
    'Symbol' => 'Symbol',
    'TLS' => 'TLS',
    'TSL' => 'TSL',
    'Tags' => 'Tags',
    'Take your events to the next level' => 'Take your events to the next level',
    'Tell your attendees more about this ticket type' => 'Tell your attendees more about this ticket type',
    'Terms of service' => 'Terms of service',
    'Terms of service page slug' => 'Terms of service page slug',
    'Test the mail server configuration' => 'Test the mail server configuration',
    'Texte du lien' => 'Texte du lien',
    'Texto del enlace' => 'Texto del enlace',
    'Texto do link' => 'Texto do link',
    'The amenity can not be deleted because it is linked with one or more venues' => 'The amenity can not be deleted because it is linked with one or more venues',
    'The amenity can not be found' => 'The amenity can not be found',
    'The amenity has been deleted' => 'The amenity has been deleted',
    'The amenity has been disabled' => 'The amenity has been disabled',
    'The amenity has been succesfully restored' => 'The amenity has been succesfully restored',
    'The amenity has been successfully created' => 'The amenity has been successfully created',
    'The amenity has been successfully updated' => 'The amenity has been successfully updated',
    'The amenity is hidden' => 'The amenity is hidden',
    'The amenity is visible' => 'The amenity is visible',
    'The article can not be found' => 'The article can not be found',
    'The article has been deleted' => 'The article has been deleted',
    'The article has been disabled' => 'The article has been disabled',
    'The article has been succesfully restored' => 'The article has been succesfully restored',
    'The article has been successfully created' => 'The article has been successfully created',
    'The article has been successfully updated' => 'The article has been successfully updated',
    'The article is featured' => 'The article is featured',
    'The article is hidden' => 'The article is hidden',
    'The article is not featured anymore' => 'The article is not featured anymore',
    'The article is visible' => 'The article is visible',
    'The article not be found' => 'The article not be found',
    'The audience can not be deleted because it is linked with one or more events' => 'The audience can not be deleted because it is linked with one or more events',
    'The audience can not be found' => 'The audience can not be found',
    'The audience has been deleted' => 'The audience has been deleted',
    'The audience has been disabled' => 'The audience has been disabled',
    'The audience has been succesfully restored' => 'The audience has been succesfully restored',
    'The audience has been successfully created' => 'The audience has been successfully created',
    'The audience has been successfully updated' => 'The audience has been successfully updated',
    'The audience is hidden' => 'The audience is hidden',
    'The audience is visible' => 'The audience is visible',
    'The blog post can not be found' => 'The blog post can not be found',
    'The blog post category can not be deleted because it is linked with one or more blog posts' => 'The blog post category can not be deleted because it is linked with one or more blog posts',
    'The blog post category can not be found' => 'The blog post category can not be found',
    'The blog post category has been deleted' => 'The blog post category has been deleted',
    'The blog post category has been disabled' => 'The blog post category has been disabled',
    'The blog post category has been succesfully restored' => 'The blog post category has been succesfully restored',
    'The blog post category has been successfully created' => 'The blog post category has been successfully created',
    'The blog post category has been successfully updated' => 'The blog post category has been successfully updated',
    'The blog post category is hidden' => 'The blog post category is hidden',
    'The blog post category is visible' => 'The blog post category is visible',
    'The blog post has been deleted' => 'The blog post has been deleted',
    'The blog post has been disabled' => 'The blog post has been disabled',
    'The blog post has been succesfully restored' => 'The blog post has been succesfully restored',
    'The blog post has been successfully created' => 'The blog post has been successfully created',
    'The blog post has been successfully updated' => 'The blog post has been successfully updated',
    'The blog post is hidden' => 'The blog post is hidden',
    'The blog post is visible' => 'The blog post is visible',
    'The blog post not be found' => 'The blog post not be found',
    'The category can not be deleted because it is linked with one or more events' => 'The category can not be deleted because it is linked with one or more events',
    'The category can not be deleted because it is linked with one or more help center articles' => 'The category can not be deleted because it is linked with one or more help center articles',
    'The category can not be found' => 'The category can not be found',
    'The category has been deleted' => 'The category has been deleted',
    'The category has been disabled' => 'The category has been disabled',
    'The category has been succesfully restored' => 'The category has been succesfully restored',
    'The category has been successfully created' => 'The category has been successfully created',
    'The category has been successfully updated' => 'The category has been successfully updated',
    'The category is featured and is shown in the homepage categories' => 'The category is featured and is shown in the homepage categories',
    'The category is hidden' => 'The category is hidden',
    'The category is not featured anymore and is removed from the homepage categories' => 'The category is not featured anymore and is removed from the homepage categories',
    'The category is visible' => 'The category is visible',
    'The category not be found' => 'The category not be found',
    'The category was not found' => 'The category was not found',
    'The confirmation email has been resent to' => 'The confirmation email has been resent to',
    'The country can not be deleted because it is linked with one or more events' => 'The country can not be deleted because it is linked with one or more events',
    'The country can not be found' => 'The country can not be found',
    'The country has been deleted' => 'The country has been deleted',
    'The country has been disabled' => 'The country has been disabled',
    'The country has been succesfully restored' => 'The country has been succesfully restored',
    'The country has been successfully created' => 'The country has been successfully created',
    'The country has been successfully updated' => 'The country has been successfully updated',
    'The country is hidden' => 'The country is hidden',
    'The country is visible' => 'The country is visible',
    'The currency can not be found' => 'The currency can not be found',
    'The currency has been deleted' => 'The currency has been deleted',
    'The currency has been successfully created' => 'The currency has been successfully created',
    'The currency has been successfully updated' => 'The currency has been successfully updated',
    'The default locale must be selected in the available languages' => 'The default locale must be selected in the available languages',
    'The email address is not valid' => 'The email address is not valid',
    'The email could not be sent' => 'The email could not be sent',
    'The event can not be deleted because it has one or more orders' => 'The event can not be deleted because it has one or more orders',
    'The event can not be found' => 'The event can not be found',
    'The event date can not be found' => 'The event date can not be found',
    'The event date stats (sales and attendance) will be visible on the scanner app' => 'The event date stats (sales and attendance) will be visible on the scanner app',
    'The event has been added to your favorites' => 'The event has been added to your favorites',
    'The event has been deleted' => 'The event has been deleted',
    'The event has been deleted permanently' => 'The event has been deleted permanently',
    'The event has been published and will figure in the search results' => 'The event has been published and will figure in the search results',
    'The event has been removed from your favorites' => 'The event has been removed from your favorites',
    'The event has been succesfully restored' => 'The event has been succesfully restored',
    'The event has been successfully created' => 'The event has been successfully created',
    'The event has been successfully updated' => 'The event has been successfully updated',
    'The event has been unpublished and will not be included in the search results' => 'The event has been unpublished and will not be included in the search results',
    'The event not be found' => 'The event not be found',
    'The event ticket can not be found' => 'The event ticket can not be found',
    'The fields preceded with a red * are mandatory' => 'The fields preceded with a red * are mandatory',
    'The form contains invalid data' => 'The form contains invalid data',
    'The homepage settings can not be loaded' => 'The homepage settings can not be loaded',
    'The homepage settings could not be loaded' => 'The homepage settings could not be loaded',
    'The language can not be deleted because it is linked with one or more events' => 'The language can not be deleted because it is linked with one or more events',
    'The language can not be found' => 'The language can not be found',
    'The language has been deleted' => 'The language has been deleted',
    'The language has been disabled' => 'The language has been disabled',
    'The language has been succesfully restored' => 'The language has been succesfully restored',
    'The language has been successfully created' => 'The language has been successfully created',
    'The language has been successfully updated' => 'The language has been successfully updated',
    'The language is hidden' => 'The language is hidden',
    'The language is visible' => 'The language is visible',
    'The layout settings could not be loaded' => 'The layout settings could not be loaded',
    'The menu can not be found' => 'The menu can not be found',
    'The menu has been successfully updated' => 'The menu has been successfully updated',
    'The order can not be found' => 'The order can not be found',
    'The order has been deleted' => 'The order has been deleted',
    'The order has been permanently canceled' => 'The order has been permanently canceled',
    'The order has been permanently deleted' => 'The order has been permanently deleted',
    'The order has been soft deleted, restore it before canceling it' => 'The order has been soft deleted, restore it before canceling it',
    'The order has been succesfully restored' => 'The order has been succesfully restored',
    'The order has been successfully validated' => 'The order has been successfully validated',
    'The order status must be paid or awaiting payment' => 'The order status must be paid or awaiting payment',
    'The organizer can not be found' => 'The organizer can not be found',
    'The organizer not be found' => 'The organizer not be found',
    'The organizer revenue from this event date is currently zero' => 'The organizer revenue from this event date is currently zero',
    'The page can not be found' => 'The page can not be found',
    'The page has been deleted' => 'The page has been deleted',
    'The page has been successfully created' => 'The page has been successfully created',
    'The page has been successfully updated' => 'The page has been successfully updated',
    'The payment can not be found' => 'The payment can not be found',
    'The payment gateway can not be found' => 'The payment gateway can not be found',
    'The payment gateway has been successfully created' => 'The payment gateway has been successfully created',
    'The payment gateway has been successfully updated' => 'The payment gateway has been successfully updated',
    'The payout method can not be found' => 'The payout method can not be found',
    'The payout method has been successfully created' => 'The payout method has been successfully created',
    'The payout method has been successfully updated' => 'The payout method has been successfully updated',
    'The payout method is unset' => 'The payout method is unset',
    'The payout request can not be canceled because it is already processed' => 'The payout request can not be canceled because it is already processed',
    'The payout request can not be found' => 'The payout request can not be found',
    'The payout request can not be processed at this moment' => 'The payout request can not be processed at this moment',
    'The payout request has been already processed' => 'The payout request has been already processed',
    'The payout request has been deleted' => 'The payout request has been deleted',
    'The payout request has been permanently canceled' => 'The payout request has been permanently canceled',
    'The payout request has been permanently deleted' => 'The payout request has been permanently deleted',
    'The payout request has been soft deleted, restore it before canceling it' => 'The payout request has been soft deleted, restore it before canceling it',
    'The payout request has been soft deleted, restore it before viewing the details' => 'The payout request has been soft deleted, restore it before viewing the details',
    'The payout request has been succesfully restored' => 'The payout request has been succesfully restored',
    'The payout request has been successfully processed' => 'The payout request has been successfully processed',
    'The payout request has been successfully submitted, you will be notified by email once it is processed' => 'The payout request has been successfully submitted, you will be notified by email once it is processed',
    'The point of sale can not be found' => 'The point of sale can not be found',
    'The point of sale has been deleted' => 'The point of sale has been deleted',
    'The point of sale has been disabled' => 'The point of sale has been disabled',
    'The point of sale has been enabled' => 'The point of sale has been enabled',
    'The point of sale has been permenently deleted' => 'The point of sale has been permenently deleted',
    'The point of sale has been successfully created' => 'The point of sale has been successfully created',
    'The point of sale has been successfully updated' => 'The point of sale has been successfully updated',
    'The refund could not been processed at this moment' => 'The refund could not been processed at this moment',
    'The refund has already been reclined' => 'The refund has already been reclined',
    'The refund has been declined' => 'The refund has been declined',
    'The refund has been successfully processed' => 'The refund has been successfully processed',
    'The refund request has already been processed or no refund has been requested' => 'The refund request has already been processed or no refund has been requested',
    'The request method is known by the server but is not supported by the target resource' => 'The request method is known by the server but is not supported by the target resource',
    'The requested page couldn\'t be located. Checkout for any URL misspelling or' => 'The requested page couldn\'t be located. Checkout for any URL misspelling or',
    'The review can not be found' => 'The review can not be found',
    'The review has been deleted' => 'The review has been deleted',
    'The review has been deleted permanently' => 'The review has been deleted permanently',
    'The review has been enabled' => 'The review has been enabled',
    'The review has been hidden' => 'The review has been hidden',
    'The review has been succesfully restored' => 'The review has been succesfully restored',
    'The scanner account is disabled by the organizer' => 'The scanner account is disabled by the organizer',
    'The scanner can not be found' => 'The scanner can not be found',
    'The scanner has been disabled' => 'The scanner has been disabled',
    'The scanner has been enabled' => 'The scanner has been enabled',
    'The scanner has been permenently deleted' => 'The scanner has been permenently deleted',
    'The scanner has been successfully created' => 'The scanner has been successfully created',
    'The scanner has been successfully updated' => 'The scanner has been successfully updated',
    'The settings have been updated' => 'The settings have been updated',
    'The space' => 'The space',
    'The test email has been sent, please check the inbox of' => 'The test email has been sent, please check the inbox of',
    'The ticket can not be found' => 'The ticket can not be found',
    'The ticket has already been scanned' => 'The ticket has already been scanned',
    'The ticket has been successfully scanned' => 'The ticket has been successfully scanned',
    'The ticket is not valid for this event date' => 'The ticket is not valid for this event date',
    'The ticket was already scanned at' => 'The ticket was already scanned at',
    'The tickets has been successfully added to your cart' => 'The tickets has been successfully added to your cart',
    'The tickets have been released' => 'The tickets have been released',
    'The user can not be found' => 'The user can not be found',
    'The user cart has been emptied' => 'The user cart has been emptied',
    'The user has been deleted' => 'The user has been deleted',
    'The user has been disabled' => 'The user has been disabled',
    'The user has been enabled' => 'The user has been enabled',
    'The user has been permanently deleted' => 'The user has been permanently deleted',
    'The user has been succesfully restored' => 'The user has been succesfully restored',
    'The username already exists' => 'The username already exists',
    'The venue can not be deleted because it is linked with one or more events' => 'The venue can not be deleted because it is linked with one or more events',
    'The venue can not be found' => 'The venue can not be found',
    'The venue has been deleted' => 'The venue has been deleted',
    'The venue has been disabled' => 'The venue has been disabled',
    'The venue has been succesfully restored' => 'The venue has been succesfully restored',
    'The venue has been successfully created' => 'The venue has been successfully created',
    'The venue has been successfully updated' => 'The venue has been successfully updated',
    'The venue is hidden' => 'The venue is hidden',
    'The venue is hidden from the public venues directory' => 'The venue is hidden from the public venues directory',
    'The venue is listed on the public venues directory' => 'The venue is listed on the public venues directory',
    'The venue is visible' => 'The venue is visible',
    'The venue type can not be deleted because it is linked with one or more venues' => 'The venue type can not be deleted because it is linked with one or more venues',
    'The venue type can not be found' => 'The venue type can not be found',
    'The venue type has been deleted' => 'The venue type has been deleted',
    'The venue type has been disabled' => 'The venue type has been disabled',
    'The venue type has been succesfully restored' => 'The venue type has been succesfully restored',
    'The venue type has been successfully created' => 'The venue type has been successfully created',
    'The venue type has been successfully updated' => 'The venue type has been successfully updated',
    'The venue type is hidden' => 'The venue type is hidden',
    'The venue type is visible' => 'The venue type is visible',
    'This email address will be used as the sender of all the emails sent by the platform, in almost all cases, it is the same as the username above' => 'This email address will be used as the sender of all the emails sent by the platform, in almost all cases, it is the same as the username above',
    'This email address will be used to receive the quote requests, make sure to mention it if you want to show the quote form' => 'This email address will be used to receive the quote requests, make sure to mention it if you want to show the quote form',
    'This email address will receive the contact form messages' => 'This email address will receive the contact form messages',
    'This email is sent as a confirmation of your order' => 'This email is sent as a confirmation of your order',
    'This email is sent to test the configuration of the mail server settings.' => 'This email is sent to test the configuration of the mail server settings.',
    'This event date is locked because a payout request has been submitted' => 'This event date is locked because a payout request has been submitted',
    'This fee will be added to the ticket sale price (leave this field blank to disable additional ticket fees)' => 'This fee will be added to the ticket sale price (leave this field blank to disable additional ticket fees)',
    'This fee will be added to the ticket sale price which are bought from a point of sale, put 0 to disable additional fees for tickets which are bought from a point of sale, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought from a point of sale, put 0 to disable additional fees for tickets which are bought from a point of sale, does not apply for free tickets, will be applied to future orders',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for ticket which are bought online, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for ticket which are bought online, does not apply for free tickets, will be applied to future orders',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for tickets which are bought online, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for tickets which are bought online, does not apply for free tickets, will be applied to future orders',
    'This is a string that should be unique to your application and it is commonly used to add more entropy to security related operations' => 'This is a string that should be unique to your application and it is commonly used to add more entropy to security related operations',
    'This link can only be used once to validate your account' => 'This link can only be used once to validate your account',
    'This month' => 'This month',
    'This order has already been refunded' => 'This order has already been refunded',
    'This order is not eligible for refund because it contains tickets from different organizers' => 'This order is not eligible for refund because it contains tickets from different organizers',
    'This order is not eligible for refund because it is not paid' => 'This order is not eligible for refund because it is not paid',
    'This payout method is currently disabled' => 'This payout method is currently disabled',
    'This percentage will be deducted from each ticket sold on a point of sale, upon organizer payout request, this percentage will be taken from each ticket sold on a point of sale, will be applied to future orders' => 'This percentage will be deducted from each ticket sold on a point of sale, upon organizer payout request, this percentage will be taken from each ticket sold on a point of sale, will be applied to future orders',
    'This percentage will be deducted from each ticket sold online, upon organizer payout request, this percentage will be taken from each ticket sold online, will be applied to future orders' => 'This percentage will be deducted from each ticket sold online, upon organizer payout request, this percentage will be taken from each ticket sold online, will be applied to future orders',
    'This ticket was scanned at %scanDate%' => 'This ticket was scanned at %scanDate%',
    'This week' => 'This week',
    'This weekend' => 'This weekend',
    'Ticket' => 'Ticket',
    'Ticket description' => 'Ticket description',
    'Ticket fee' => 'Ticket fee',
    'Ticket fee (Online)' => 'Ticket fee (Online)',
    'Ticket fee (Point Of Sale)' => 'Ticket fee (Point Of Sale)',
    'Ticket fees' => 'Ticket fees',
    'Ticket name' => 'Ticket name',
    'Ticket price' => 'Ticket price',
    'Ticket price percentage cut (Online)' => 'Ticket price percentage cut (Online)',
    'Ticket price percentage cut (Point of sale)' => 'Ticket price percentage cut (Point of sale)',
    'Ticket style' => 'Ticket style',
    'Ticket type' => 'Ticket type',
    'Tickets' => 'Tickets',
    'Tickets left' => 'Tickets left',
    'Tickets per attendee' => 'Tickets per attendee',
    'Tickets sales' => 'Tickets sales',
    'Tickets sales by date' => 'Tickets sales by date',
    'Tickets sales this month' => 'Tickets sales this month',
    'Tickets sold' => 'Tickets sold',
    'Tickets sold Per Point of sale' => 'Tickets sold Per Point of sale',
    'Tickets sold by channel' => 'Tickets sold by channel',
    'Tickets types' => 'Tickets types',
    'Time\'s up' => 'Time\'s up',
    'Timeleft' => 'Timeleft',
    'Timezone' => 'Timezone',
    'Titel' => 'Titel',
    'Title' => 'Title',
    'Titre' => 'Titre',
    'To help attendee find your event quickly, enter some keywords that identify your event (press Enter after each entry)' => 'To help attendee find your event quickly, enter some keywords that identify your event (press Enter after each entry)',
    'To reset your password, click on the following button and follow the instructions' => 'To reset your password, click on the following button and follow the instructions',
    'To submit a new payout request for an event date, go to the My events page and click on the Request payout link next to the event' => 'To submit a new payout request for an event date, go to the My events page and click on the Request payout link next to the event',
    'Today' => 'Today',
    'Toggle display the event date details' => 'Toggle display the event date details',
    'Toggle display the search filters' => 'Toggle display the search filters',
    'Tomorrow' => 'Tomorrow',
    'Total' => 'Total',
    'Total attendees' => 'Total attendees',
    'Total attendees check-in' => 'Total attendees check-in',
    'Total gross sales' => 'Total gross sales',
    'Total orders' => 'Total orders',
    'Total sales' => 'Total sales',
    'Total tickets sales' => 'Total tickets sales',
    'Translation' => 'Translation',
    'Translations' => 'Translations',
    'Transport' => 'Transport',
    'Twitter' => 'Twitter',
    'Twitter url' => 'Twitter url',
    'Type' => 'Type',
    'Título' => 'Título',
    'Unfollow' => 'Unfollow',
    'Unknown' => 'Unknown',
    'Unstick' => 'Unstick',
    'Until date' => 'Until date',
    'Upcoming events' => 'Upcoming events',
    'Upcoming tickets' => 'Upcoming tickets',
    'Update cart' => 'Update cart',
    'Update date' => 'Update date',
    'Update the amenity' => 'Update the amenity',
    'Update the audience' => 'Update the audience',
    'Update the blog post' => 'Update the blog post',
    'Update the blog post category' => 'Update the blog post category',
    'Update the category' => 'Update the category',
    'Update the country' => 'Update the country',
    'Update the currency' => 'Update the currency',
    'Update the event' => 'Update the event',
    'Update the help center article' => 'Update the help center article',
    'Update the help center category' => 'Update the help center category',
    'Update the language' => 'Update the language',
    'Update the lapagenguage' => 'Update the page',
    'Update the payment gateway' => 'Update the payment gateway',
    'Update the point of sale' => 'Update the point of sale',
    'Update the scanner' => 'Update the scanner',
    'Update the venue' => 'Update the venue',
    'Update the venue type' => 'Update the venue type',
    'Update your %payoutMethodName% payout method' => 'Update your %payoutMethodName% payout method',
    'Used in some specific cases, follow this link for a list of supported characters: https://www.php.net/manual/en/datetime.format.php . Please make sure to keep the double quotes " " around the format string' => 'Used in some specific cases, follow this link for a list of supported characters: https://www.php.net/manual/en/datetime.format.php . Please make sure to keep the double quotes " " around the format string',
    'Useful Links' => 'Useful Links',
    'User information' => 'User information',
    'Username' => 'Username',
    'Users' => 'Users',
    'Users summary' => 'Users summary',
    'Uset' => 'Uset',
    'Validate' => 'Validate',
    'Venue' => 'Venue',
    'Venue / Location' => 'Venue / Location',
    'Venue image' => 'Venue image',
    'Venue name...' => 'Venue name...',
    'Venue page' => 'Venue page',
    'Venue page settings' => 'Venue page settings',
    'Venue type' => 'Venue type',
    'Venue types' => 'Venue types',
    'Venues' => 'Venues',
    'Venues Pages' => 'Venues Pages',
    'Venues count' => 'Venues count',
    'Venues page' => 'Venues page',
    'Video' => 'Video',
    'View cart' => 'View cart',
    'View detailed statistics' => 'View detailed statistics',
    'View details' => 'View details',
    'View event' => 'View event',
    'View organizer' => 'View organizer',
    'View stats' => 'View stats',
    'Views' => 'Views',
    'Visible' => 'Visible',
    'Visible only' => 'Visible only',
    'We recommend a 48x48 image' => 'We recommend a 48x48 image',
    'We recommend a 48x48 image size' => 'We recommend a 48x48 image size',
    'We will be back shortly.' => 'We will be back shortly.',
    'Website' => 'Website',
    'Website description' => 'Website description',
    'Website name' => 'Website name',
    'Website root url' => 'Website root url',
    'Website slug' => 'Website slug',
    'Website url' => 'Website url',
    'Welcome' => 'Welcome',
    'What to show in the homepage hero ?' => 'What to show in the homepage hero ?',
    'When' => 'When',
    'Where' => 'Where',
    'Will be show in the homepage, the explore menu item dropdown and in the footer' => 'Will be show in the homepage, the explore menu item dropdown and in the footer',
    'With sales only' => 'With sales only',
    'Without sales only' => 'Without sales only',
    'Year' => 'Year',
    'Yellow' => 'Yellow',
    'Yes' => 'Yes',
    'You are about to approve the payout request' => 'You are about to approve the payout request',
    'You are about to cancel this order (this action cannot be undone)' => 'You are about to cancel this order (this action cannot be undone)',
    'You are about to cancel this payout request (this action cannot be undone), the event date related to this payout request will be unlocked' => 'You are about to cancel this payout request (this action cannot be undone), the event date related to this payout request will be unlocked',
    'You are about to delete the amenity PERMANENTLY' => 'You are about to delete the amenity PERMANENTLY',
    'You are about to delete the article PERMANENTLY' => 'You are about to delete the article PERMANENTLY',
    'You are about to delete the audience PERMANENTLY' => 'You are about to delete the audience PERMANENTLY',
    'You are about to delete the blog post PERMANENTLY' => 'You are about to delete the blog post PERMANENTLY',
    'You are about to delete the blog post category PERMANENTLY' => 'You are about to delete the blog post category PERMANENTLY',
    'You are about to delete the category PERMANENTLY' => 'You are about to delete the category PERMANENTLY',
    'You are about to delete the country PERMANENTLY' => 'You are about to delete the country PERMANENTLY',
    'You are about to delete the currency PERMANENTLY' => 'You are about to delete the currency PERMANENTLY',
    'You are about to delete the event and all its related information PERMANENTLY' => 'You are about to delete the event and all its related information PERMANENTLY',
    'You are about to delete the language PERMANENTLY' => 'You are about to delete the language PERMANENTLY',
    'You are about to delete the order and all its related information (payment details, tickets...)' => 'You are about to delete the order and all its related information (payment details, tickets...)',
    'You are about to delete the page PERMANENTLY' => 'You are about to delete the page PERMANENTLY',
    'You are about to delete the payout request and all its related information' => 'You are about to delete the payout request and all its related information',
    'You are about to delete the point of sale' => 'You are about to delete the point of sale',
    'You are about to delete the point of sale PERMANENTLY' => 'You are about to delete the point of sale PERMANENTLY',
    'You are about to delete the review PERMANENTLY' => 'You are about to delete the review PERMANENTLY',
    'You are about to delete the scanner' => 'You are about to delete the scanner',
    'You are about to delete the scanner PERMANENTLY' => 'You are about to delete the scanner PERMANENTLY',
    'You are about to delete the user and all its related information (orders, events...) PERMANENTLY' => 'You are about to delete the user and all its related information (orders, events...) PERMANENTLY',
    'You are about to delete the venue PERMANENTLY' => 'You are about to delete the venue PERMANENTLY',
    'You are about to delete the venue type PERMANENTLY' => 'You are about to delete the venue type PERMANENTLY',
    'You are about to empty your cart' => 'You are about to empty your cart',
    'You are about to validate this order, generate the tickets and send a confirmation email to the attendee' => 'You are about to validate this order, generate the tickets and send a confirmation email to the attendee',
    'You are connected as "%username%' => 'You are connected as "%username%',
    'You are following this organizer' => 'You are following this organizer',
    'You are going to this event' => 'You are going to this event',
    'You are logged in as:' => 'You are logged in as:',
    'You are no longer following this organizer' => 'You are no longer following this organizer',
    'You are not following any organizer' => 'You are not following any organizer',
    'You can introduce the event details in multiple locales' => 'You can introduce the event details in multiple locales',
    'You did not find an answer to your inquiry? Let us know and we will be glad to give you further help' => 'You did not find an answer to your inquiry? Let us know and we will be glad to give you further help',
    'You don\'t have permission to access this resource' => 'You don\'t have permission to access this resource',
    'You have added %tickets% ticket(s) to your cart' => 'You have added %tickets% ticket(s) to your cart',
    'You have already bought %tickets% ticket(s)' => 'You have already bought %tickets% ticket(s)',
    'You have already requested a refund for this order' => 'You have already requested a refund for this order',
    'You have already requested a refund for this order and it was approved' => 'You have already requested a refund for this order and it was approved',
    'You have already requested a refund for this order and it was declined' => 'You have already requested a refund for this order and it was declined',
    'You have received a new quote request for the venue' => 'You have received a new quote request for the venue',
    'You have successfully subscribed to our newsletter' => 'You have successfully subscribed to our newsletter',
    'You must choose an event and set the status to paid in order to export attendees list to a PDF file' => 'You must choose an event and set the status to paid in order to export attendees list to a PDF file',
    'You must choose an event in order to export the attendees list' => 'You must choose an event in order to export the attendees list',
    'You must review your cart before proceeding to checkout' => 'You must review your cart before proceeding to checkout',
    'You must set the status to paid in order to export the attendees list' => 'You must set the status to paid in order to export the attendees list',
    'You must specify at least one language' => 'You must specify at least one language',
    'You order is empty' => 'You order is empty',
    'Your account settings have been updated' => 'Your account settings have been updated',
    'Your cart has been automatically updated because one or more event\'s quotas has changed' => 'Your cart has been automatically updated because one or more event\'s quotas has changed',
    'Your cart has been automatically updated because one or more events are no longer on sale' => 'Your cart has been automatically updated because one or more events are no longer on sale',
    'Your cart has been emptied' => 'Your cart has been emptied',
    'Your cart has been updated' => 'Your cart has been updated',
    'Your cart is empty' => 'Your cart is empty',
    'Your email' => 'Your email',
    'Your message has been successfully sent' => 'Your message has been successfully sent',
    'Your order has been automatically canceled because one or more event\'s quotas has changed' => 'Your order has been automatically canceled because one or more event\'s quotas has changed',
    'Your order has been automatically canceled because one or more events are no longer on sale' => 'Your order has been automatically canceled because one or more events are no longer on sale',
    'Your order has been automatically canceled because your ticket reservations has been released' => 'Your order has been automatically canceled because your ticket reservations has been released',
    'Your order has been successfully placed, please proceed to the payment as explained in the instructions' => 'Your order has been successfully placed, please proceed to the payment as explained in the instructions',
    'Your organizer profile has been successfully updated' => 'Your organizer profile has been successfully updated',
    'Your payment could not be processed at this time' => 'Your payment could not be processed at this time',
    'Your payment has been successfully processed' => 'Your payment has been successfully processed',
    'Your payment operation was canceled' => 'Your payment operation was canceled',
    'Your payout request has been processed' => 'Your payout request has been processed',
    'Your quote request has been successfully sent' => 'Your quote request has been successfully sent',
    'Your rating (out of 5 stars)' => 'Your rating (out of 5 stars)',
    'Your refund request has been successfully submitted to the organizer' => 'Your refund request has been successfully submitted to the organizer',
    'Your registration has been successfully processed' => 'Your registration has been successfully processed',
    'Your review has been successfully saved' => 'Your review has been successfully saved',
    'Your review headline' => 'Your review headline',
    'Your tickets are not reserved until checkout, the quantity you intend to buy might not be available if you do not proceed to checkout right away' => 'Your tickets are not reserved until checkout, the quantity you intend to buy might not be available if you do not proceed to checkout right away',
    'Your tickets bought from' => 'Your tickets bought from',
    'Youtube' => 'Youtube',
    'Youtube url' => 'Youtube url',
    'Youtube video' => 'Youtube video',
    'Youtube video url' => 'Youtube video url',
    'Zip / Postal code' => 'Zip / Postal code',
    'and' => 'and',
    'asc' => 'asc',
    'at' => 'at',
    'checked In' => 'checked In',
    'created at' => 'created at',
    'desc' => 'desc',
    'event to the next level ?' => 'event to the next level ?',
    'for' => 'for',
    'form.label.delete' => 'Delete',
    'form.password' => 'form.password',
    'form.password_confirmation' => 'form.password_confirmation',
    'image(s)' => 'image(s)',
    'left' => 'left',
    'left before tickets are released' => 'left before tickets are released',
    'min read' => 'min read',
    'my points of sale' => 'my points of sale',
    'my scanners' => 'my scanners',
    'my venues' => 'my venues',
    'orders summary' => 'orders summary',
    'out of 5 stars' => 'out of 5 stars',
    'placed on' => 'placed on',
    'return to the homepage' => 'return to the homepage',
    'review' => 'review',
    'right' => 'right',
    'ticket' => 'ticket',
    'ticket(s)' => 'ticket(s)',
    'ticket(s) sold' => 'ticket(s) sold',
    'tickets' => 'tickets',
    'tickets found in your cart' => 'tickets found in your cart',
    'tickets left' => 'tickets left',
    'tickets per attendee' => 'tickets per attendee',
    'title' => 'title',
    'to edit your profile' => 'to edit your profile',
    'to manage this event' => 'to manage this event',
    'to manage your event' => 'to manage your event',
    'to preview your profile' => 'to preview your profile',
    'to return to your dashboard' => 'to return to your dashboard',
    'user(s)' => 'user(s)',
    'view(s)' => 'view(s)',
    'views' => 'views',
    'your payout request has been processed' => 'your payout request has been processed',
    'your tickets are ready to go!' => 'your tickets are ready to go!',
    'اسم' => 'اسم',
    'اسم القائمة' => 'اسم القائمة',
    'التفاصيل' => 'التفاصيل',
    'العلامات' => 'العلامات',
    'الكلمات الرئيسية' => 'الكلمات الرئيسية',
    'تعليمات' => 'تعليمات',
    'عنوان' => 'عنوان',
    'فقرة' => 'فقرة',
    'محتوى' => 'محتوى',
    'نص الرابط' => 'نص الرابط',
    'نص العنوان' => 'نص العنوان',
    '关键字' => '关键字',
    '内容' => '内容',
    '名称' => '名称',
    '描述' => '描述',
    '标签' => '标签',
    '标题' => '标题',
    '段' => '段',
  ),
  'javascript' => 
  array (
    'Add' => 'Add',
    'Add a new event date' => 'Add a new event date',
    'Add a new ticket' => 'Add a new ticket',
    'An error has occured' => 'An error has occured',
    'April' => 'April',
    'August' => 'August',
    'Cancel' => 'Cancel',
    'Close' => 'Close',
    'Confirm' => 'Confirm',
    'Confirmation required' => 'Confirmation required',
    'Day' => 'Day',
    'December' => 'December',
    'Duplicate this event date' => 'Duplicate this event date',
    'Duplicate this ticket' => 'Duplicate this ticket',
    'Email address' => 'Email address',
    'February' => 'February',
    'Insert at least 3 characters' => 'Insert at least 3 characters',
    'January' => 'January',
    'July' => 'July',
    'June' => 'June',
    'Load more' => 'Load more',
    'Loading...' => 'Loading...',
    'Mail server test email' => 'Mail server test email',
    'Make sure to enter a valid email address' => 'Make sure to enter a valid email address',
    'March' => 'March',
    'May' => 'May',
    'Message' => 'Message',
    'Month' => 'Month',
    'Move down' => 'Move down',
    'Move up' => 'Move up',
    'No results found' => 'No results found',
    'Note' => 'Note',
    'November' => 'November',
    'October' => 'October',
    'Please select the tickets quantity for this order' => 'Please select the tickets quantity for this order',
    'Please select the tickets quantity you want to buy' => 'Please select the tickets quantity you want to buy',
    'Read more' => 'Read more',
    'Remove' => 'Remove',
    'Remove this event date' => 'Remove this event date',
    'Remove this ticket' => 'Remove this ticket',
    'Return to cart' => 'Return to cart',
    'Searching ...' => 'Searching ...',
    'Select an option' => 'Select an option',
    'Send' => 'Send',
    'September' => 'September',
    'Stick' => 'Stick',
    'The email address is not valid' => 'The email address is not valid',
    'The tickets have been released' => 'The tickets have been released',
    'This feature is disabled in demo mode' => 'This feature is disabled in demo mode',
    'Time\'s up' => 'Time\'s up',
    'Today' => 'Today',
    'Unstick' => 'Unstick',
    'Week' => 'Week',
    'days' => 'days',
    'days.Fri' => 'Fri',
    'days.Mon' => 'Mon',
    'days.Sat' => 'Sat',
    'days.Sun' => 'Sun',
    'days.Thu' => 'Thu',
    'days.Tue' => 'Tue',
    'days.Wed' => 'Wed',
    'hr' => 'hr',
    'javascript string translation' => 'javascript string translation',
    'min' => 'min',
    'sec' => 'sec',
    'weeks' => 'weeks',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
