<?php

namespace App\Repository;

use App\Entity\OrderTicket;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

class OrderTicketRepository extends ServiceEntityRepository {

    public function __construct(ManagerRegistry $registry) {
        parent::__construct($registry, OrderTicket::class);
    }

    public function getOrderTickets($reference, $keyword, $eventDate, $checkedin) {
    $qb = $this->createQueryBuilder("t");
    $qb->select("t");
    if ($reference !== "all") {
        $qb->andWhere("t.reference = :reference")->setParameter("reference", $reference);
    }
    if ($keyword !== "all" || $eventDate !== "all") {
        $qb->leftJoin("t.orderelement", "orderelement");
    }
    if ($keyword !== "all") {
        $qb->leftJoin("orderelement.order", "o");
        $qb->leftJoin("o.payment", "payment");
        // Updated: add attendee first/last/full name on the ticket and on the payment
        $qb->andWhere(
            $qb->expr()->orX(
                "t.reference LIKE :keyword",
                ":keyword LIKE t.reference",
                "o.reference LIKE :keyword",
                ":keyword LIKE o.reference",
                "payment.clientEmail LIKE :keyword",
                ":keyword LIKE payment.clientEmail",
                "payment.firstName LIKE :keyword",
                ":keyword LIKE payment.firstName",
                "payment.lastName LIKE :keyword",
                ":keyword LIKE payment.lastName",
                "LOWER(t.firstName) LIKE :keyword_lc",
                "LOWER(t.lastName) LIKE :keyword_lc",
                "LOWER(CONCAT(t.firstName, ' ', t.lastName)) LIKE :keyword_lc"
            )
        )
        ->setParameter("keyword", "%" . trim($keyword) . "%")
        ->setParameter("keyword_lc", "%" . mb_strtolower(trim($keyword)) . "%");
    }
    if ($eventDate !== "all") {
        $qb->leftJoin("orderelement.eventticket", "eventticket");
        $qb->leftJoin("eventticket.eventdate", "eventdate");
        $qb->andWhere("eventdate.reference = :eventdate")->setParameter("eventdate", $eventDate);
    }
    if ($checkedin !== "all") {
        if ($checkedin == "1") {
            $qb->andWhere("t.scanned = 1");
        } elseif ($checkedin == "0") {
            $qb->andWhere("t.scanned = 0");
        }
    }
    $qb->orderBy("t.createdAt", "DESC");
    return $qb;
}
}
