<?php

namespace App\Controller\Dashboard\Administrator;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Knp\Component\Pager\PaginatorInterface;
use App\Service\AppServices;
use Symfony\Contracts\Translation\TranslatorInterface;
use App\Entity\User;

class UserController extends Controller
{
    /**
     * @Route("/manage-users", name="user", methods="GET")
     */
    public function index(Request $request, PaginatorInterface $paginator, AppServices $services)
    {
        $role = ($request->query->get('role')) ?? "all";
        $createdbyorganizerslug = ($request->query->get('createdbyorganizerslug')) ?? "all";
        $organizername = ($request->query->get('organizername')) ?? "all";
        $username = ($request->query->get('username')) ?? "all";
        $email = ($request->query->get('email')) ?? "all";
        $firstname = ($request->query->get('firstname')) ?? "all";
        $lastname = ($request->query->get('lastname')) ?? "all";
        $enabled = ($request->query->get('enabled')) ?? "all";
        $countryslug = ($request->query->get('countryslug')) ?? "all";

        $users = $paginator->paginate(
            $services->getUsers([
                'role' => $role,
                'createdbyorganizerslug' => $createdbyorganizerslug,
                'organizername' => $organizername,
                'username' => $username,
                'email' => $email,
                'firstname' => $firstname,
                'lastname' => $lastname,
                'enabled' => $enabled,
                'countryslug' => $countryslug
            ]),
            $request->query->getInt('page', 1),
            10,
            ['wrap-queries' => true]
        );

        return $this->render('Dashboard/Administrator/User/index.html.twig', [
            'users' => $users
        ]);
    }

    /**
     * @Route("/manage-users/{id}/delete-permanently", name="user_delete_permanently", methods="GET")
     * @Route("/manage-users/{id}/delete", name="user_delete", methods="GET")
     */
    public function delete(AppServices $services, TranslatorInterface $translator, $id)
    {
        $user = $this->getDoctrine()->getRepository(User::class)->find($id);
        if (!$user) {
            $this->addFlash('error', $translator->trans('The user can not be found'));
            return $services->redirectToReferer('user');
        }
        $em = $this->getDoctrine()->getManager();

        if ($user->getDeletedAt() !== null) {
            $this->addFlash('error', $translator->trans('The user has been permanently deleted'));
        } else {
            $this->addFlash('notice', $translator->trans('The user has been deleted'));
        }
        $em->remove($user);
        $em->flush();
        return $services->redirectToReferer('user');
    }

    /**
     * @Route("/manage-users/{id}/restore", name="user_restore", methods="GET")
     */
    public function restore($id, Request $request, TranslatorInterface $translator, AppServices $services)
    {
        $user = $this->getDoctrine()->getRepository(User::class)->find($id);
        if (!$user) {
            $this->addFlash('error', $translator->trans('The user can not be found'));
            return $services->redirectToReferer('user');
        }
        $user->setDeletedAt(null);
        $em = $this->getDoctrine()->getManager();
        $em->persist($user);
        $em->flush();
        $this->addFlash('success', $translator->trans('The user has been succesfully restored'));

        return $services->redirectToReferer('user');
    }

    /**
     * @Route("/manage-users/{id}/enable", name="user_enable", methods="GET")
     * @Route("/manage-users/{id}/disable", name="user_disable", methods="GET")
     */
    public function enabledisable(AppServices $services, TranslatorInterface $translator, $id)
    {
        $user = $this->getDoctrine()->getRepository(User::class)->find($id);
        if (!$user) {
            $this->addFlash('error', $translator->trans('The user can not be found'));
            return $services->redirectToReferer('page');
        }
        $em = $this->getDoctrine()->getManager();
        if ($user->isEnabled()) {
            $user->setEnabled(false);
            if ($user->hasRole("ROLE_ORGANIZER") && $user->getOrganizer()) {
                foreach ($user->getOrganizer()->getScanners() as $scanner) {
                    $scanner->getUser()->setEnabled(false);
                    $em->persist($scanner->getUser());
                }
                foreach ($user->getOrganizer()->getPointofsales() as $pos) {
                    $pos->getUser()->setEnabled(false);
                    $em->persist($pos->getUser());
                }
            }
            $this->addFlash('notice', $translator->trans('The user has been disabled'));
        } else {
            $user->setEnabled(true);
            if ($user->hasRole("ROLE_ORGANIZER") && $user->getOrganizer()) {
                foreach ($user->getOrganizer()->getScanners() as $scanner) {
                    $scanner->getUser()->setEnabled(true);
                    $em->persist($scanner->getUser());
                }
                foreach ($user->getOrganizer()->getPointofsales() as $pos) {
                    $pos->getUser()->setEnabled(true);
                    $em->persist($pos->getUser());
                }
            }
            $this->addFlash('success', $translator->trans('The user has been enabled'));
        }
        $em->persist($user);
        $em->flush();
        return $services->redirectToReferer('page');
    }

    /**
     * @Route("/administrator/manage-users/{id}/more-information", name="user_information", methods="GET")
     */
    public function details(AppServices $services, TranslatorInterface $translator, $id)
    {
        $user = $this->getDoctrine()->getRepository(User::class)->find($id);
        if (!$user) {
            return new Response($translator->trans('The user can not be found'));
        }
        return $this->render('Dashboard/Administrator/User/information.html.twig', [
            'user' => $user,
        ]);
    }

    /**
     * @Route("/administrator/manage-users/{id}/empty-cart", name="user_empty_cart", methods="GET")
     */
    public function emptyCart(AppServices $services, TranslatorInterface $translator, $id)
    {
        $user = $this->getDoctrine()->getRepository(User::class)->find($id);
        if (!$user) {
            $this->addFlash('error', $translator->trans('The user can not be found'));
            return $services->redirectToReferer('page');
        }
        $services->emptyCart($user);
        $this->addFlash('notice', $translator->trans('The user cart has been emptied'));
        return $services->redirectToReferer('page');
    }
}